/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.AssertionServiceWrapper;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.SiteTransfer;
import info.dragonlady.sso.helper.AttributeGenerator;
import info.dragonlady.sso.helper.AuthenticationException;
import info.dragonlady.sso.helper.Authenticator;
import info.dragonlady.sso.helper.GenerationException;
import info.dragonlady.sso.helper.SSOServletConfig;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteTransferServlet
extends HttpServlet {
    protected String paramNameKind = "kind";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Authenticator authenticator;
            String kind = this.getInitParameter(this.paramNameKind);
            String id = request.getSession().getId();
            String authId = null;
            if (SSOServletConfig.isAuthRequired(kind) && !(authenticator = (Authenticator)Class.forName(SSOServletConfig.getAuthClassName(kind)).newInstance()).authenticate(request)) {
                throw new AuthenticationException("Failed to authenticate user.");
            }
            authId = (String)request.getSession().getAttribute(SSOServletConfig.getSessionLoginKey());
            AttributeGenerator attrGenerator = (AttributeGenerator)Class.forName(SSOServletConfig.getAttributesClassName(kind)).newInstance();
            Map attributes = attrGenerator.generateAttributesMap(request);
            SiteTransfer st = new SiteTransfer(request, response);
            st.forwardTo(id, authId, attributes);
            if (!SSOServletConfig.isClusterStandalone()) {
                AssertionServiceWrapper.put(id, AssertionManager.getInstance().get(id));
            }
        }
        catch (AuthenticationException e) {
            this.processException(e, response, 403);
        }
        catch (GenerationException e) {
            this.processException(e, response, 403);
        }
        catch (SSOException e) {
            this.processException((Exception)((Object)e), response, 403);
        }
        catch (Exception e) {
            this.processException(e, response, 404);
        }
    }

    private void processException(Exception e, HttpServletResponse response, int statusCode) throws ServletException {
        try {
            e.printStackTrace();
            if (!response.isCommitted()) {
                String redirectionUrl = SSOServletConfig.getRedirection();
                if (redirectionUrl != null && redirectionUrl.length() > 0) {
                    response.sendRedirect(redirectionUrl);
                } else {
                    response.sendError(statusCode);
                }
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

