/*
 * @(#)AssertionServiceWrapper.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.message.SSOMessageResource;

import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;

import org.opensaml.SAMLAssertion;

/**
 * AT[VpT[rXbp[NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.5 $ $Date: 2006/09/26 08:16:04 $
 */
public class AssertionServiceWrapper {

	/**
	 * RXgN^B
	 */
	public AssertionServiceWrapper() {
		super();
	}

	/**
	 * [JT[oyуNX^OT[õAT[VݒB
	 * 
	 * @param id AT[VǗID
	 * @param assertion AT[V
	 * @throws AssertionServiceException
	 */
	public static final void put(String id, SAMLAssertion assertion) throws AssertionServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[oɏݒ
					String name = SSOServletConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					// nh擾
					String handleStr = (String)AssertionManager.getInstance().getHandleMap().get(id);
					// SAMLAssertionSerializeĂȂׁAStringő
					service.put(id, handleStr, assertion.toString());
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new AssertionServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õAT[V񂩂w胆[UR[h̏폜B
	 * 
	 * @param id AT[VǗID
	 * @throws AssertionServiceException
	 */
	public static final void remove(String id) throws AssertionServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o폜
					String name = SSOServletConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					service.removeById(id);
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new AssertionServiceException(message, e);
		}
	}

	/**
	 * [JT[õAT[VNX^OT[õAT[VƓB
	 * 
	 * @throws AssertionServiceException
	 */
	public static final void synchronize() throws AssertionServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o擾
					String name = SSOServletConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					Map handleMap = service.getHandleMap();
					Map assertionMap = service.getAssertionMap();
					if(handleMap != null && assertionMap != null) {
						// [JT[oɏݒ
						AssertionManager.getInstance().setHandleMap(handleMap);
						AssertionManager.getInstance().setAssertionMap(assertionMap);
						break;
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new AssertionServiceException(message, e);
		}
	}

}
