/*
 * @(#)UserService.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;

/**
 * [UǗT[rXC^[tF[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.3 $ $Date: 2006/03/09 14:43:01 $
 */
public interface UserService extends Remote {

	/**
	 * T[rX萔B
	 */
	public static final String SERVICE_NAME = "UserService";

	/**
	 * [UǉB
	 * 
	 * @param userName [U
	 * @param relationId [UƕRÂID
	 * @return boolean trueFǉ^falseFǉs
	 * @throws RemoteException
	 */
	public boolean add(String userName, String relationId) throws RemoteException;

	/**
	 * [U폜B
	 * 
	 * @param userName [U
	 * @return boolean trueF폜^falseF폜s
	 * @throws RemoteException
	 */
	public boolean remove(String userName) throws RemoteException;

	/**
	 * [UɕRÂǗpIDŃ[U폜B
	 * 
	 * @param relationId [UɕRÂID
	 * @return boolean trueF폜^falseF폜s
	 * @throws RemoteException
	 */
	public boolean removeByRelationId(String relationId) throws RemoteException;

	/**
	 * [UǗ}bv擾B
	 * 
	 * @return Map [UǗ}bvikey:[UAvalue:֘AIDj
	 * @throws RemoteException
	 */
	public Map get() throws RemoteException;

	/**
	 * [UꗗݒB
	 * 
	 * @param users [UǗ}bvikey:[UAvalue:֘AIDj
	 * @throws RemoteException
	 */
	public void set(Map users) throws RemoteException;

}
