/*
 * @(#)UserServiceImpl.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

/**
 * [UǗT[rXNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.7 $ $Date: 2006/06/12 13:27:57 $
 */
public class UserServiceImpl extends UnicastRemoteObject implements UserService {

	/**
	 * RXgN^B
	 */
	public UserServiceImpl() throws RemoteException {
		super();
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @throws RemoteException
	 */
	public UserServiceImpl(int port) throws RemoteException {
		super(port);
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @param csf [gIuWFNǧĂяoɎgpANCAg\Pbgt@Ng
	 * @param ssf [gIuWFNgĂяoMAT[o\Pbgt@Ng
	 * @throws RemoteException
	 */
	public UserServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
		super(port, csf, ssf);
	}

	/**
	 * [UǉB
	 * 
	 * @param userName [U
	 * @param relationId [UƕRÂID
	 * @return boolean trueFǉ^falseFǉs
	 * @throws RemoteException
	 * @see com.sony.ecg.ecg0100.pim.cluster.UserService#add(java.lang.String, java.lang.String)
	 */
	public synchronized boolean add(String userName, String relationId) throws RemoteException {
		try {
			LoginManager lm = LoginManager.getInstance();
			if(!lm.isLoggedIn(userName)) {
				lm.add(userName, relationId);
			}
			return true;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * [U폜B
	 * 
	 * @param userName [U
	 * @return boolean trueF폜^falseF폜s
	 * @throws RemoteException
	 * @see com.sony.ecg.ecg0100.pim.cluster.UserService#remove(java.lang.String)
	 */
	public synchronized boolean remove(String userName) throws RemoteException {
		try {
			LoginManager lm = LoginManager.getInstance();
			if(lm.isLoggedIn(userName)) {
				lm.remove(userName);
			}
			return true;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * [UɕRÂǗpIDŃ[U폜B
	 * 
	 * @param relationId [UɕRÂID
	 * @return boolean trueF폜^falseF폜s
	 * @throws RemoteException
	 */
	public boolean removeByRelationId(String relationId) throws RemoteException {
		try {
			LoginManager lm = LoginManager.getInstance();
			lm.removeById(relationId);
			return true;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * [UǗ}bv擾B
	 * 
	 * @return Map [UǗ}bvikey:[UAvalue:֘AIDj
	 * @throws RemoteException
	 * @see com.sony.ecg.ecg0100.pim.cluster.UserService#get()
	 */
	public synchronized Map get() throws RemoteException {
		try {
			LoginManager lm = LoginManager.getInstance();
			Map map = lm.getMap();
			return map;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			RemoteException ex = new RemoteException(message);
			ex.initCause(e);
			throw ex;
		}
	}

	/**
	 * [UꗗݒB
	 * 
	 * @param users [UǗ}bvikey:[UAvalue:֘AIDj
	 * @throws RemoteException
	 * @see com.sony.ecg.ecg0100.pim.cluster.UserService#set(java.util.Map)
	 */
	public synchronized void set(Map users) throws RemoteException {
		try {
			LoginManager lm = LoginManager.getInstance();
			lm.setMap(users);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			RemoteException ex = new RemoteException(message);
			ex.initCause(e);
			throw ex;
		}
	}

}
