/*
 * @(#)AssertionSessionListener.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.listener;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import info.dragonlady.cluster.AssertionServiceWrapper;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.helper.SSOServletConfig;

/**
 * AT[VǗp̃Xi[NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/09 16:17:17 $
 */
public class AssertionSessionListener implements HttpSessionListener {

	/**
	 * RXgN^B
	 */
	public AssertionSessionListener() {
	}

	/**
	 * ZbV쐬ʒmB
	 * 
	 * @param event Cxg
	 * @see javax.servlet.http.HttpSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionCreated(HttpSessionEvent event) {
		// Ȃ
	}

	/**
	 * ZbVʒmB
	 * 
	 * @param event Cxg
	 * @see javax.servlet.http.HttpSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionDestroyed(HttpSessionEvent event) {
		try {
			HttpSession session = event.getSession();
			if(session != null) {
				String id = session.getId();
				AssertionManager.getInstance().removeById(id);
				// Uł̃AT[V폜
				if(!SSOServletConfig.isClusterStandalone()) {
					AssertionServiceWrapper.remove(id);
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

}
