/*
 * @(#)LoginCheckFilterTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.filter;

import info.dragonlady.sso.filter.LoginCheckFilter;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;


import org.apache.cactus.FilterTestCase;
import org.apache.cactus.WebRequest;

/**
 * LoginCheckFilter NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/12 13:21:25 $
 */
public class LoginCheckFilterTest extends FilterTestCase {

	private String id = "00000000000e";

	/**
	 * @param arg0
	 */
	public LoginCheckFilterTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.filter.LoginCheckFilter#LoginCheckFilter()} ̂߂̃eXgE\bhB
	 */
	public final void testLoginCheckFilter() {
		try {
			new LoginCheckFilter();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.filter.LoginCheckFilter#init(javax.servlet.FilterConfig)} ̂߂̃eXgE\bhB
	 */
	public final void testInit() {
		try {
			LoginCheckFilter filter = new LoginCheckFilter();
			filter.init(config);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * @param theRequest
	 */
	public final void beginDoFilter(WebRequest theRequest) {
		try {
			theRequest.addParameter(SSOServletConfig.getRequestParamLoginKey(), id, WebRequest.GET_METHOD);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.filter.LoginCheckFilter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)} ̂߂̃eXgE\bhB
	 */
	public final void testDoFilter() {
		try {
			login();

			LoginManager.getInstance().remove(id);
			assertTrue(!LoginManager.getInstance().isLoggedIn(id));

			String authClass = "info.dragonlady.sso.helper.CooperationAuthenticator";
			String redirection = "/";
			String ignore = "";

			config.setInitParameter("auth-class", authClass);
			config.setInitParameter("redirection", redirection);
			config.setInitParameter("ignore", ignore);

			LoginCheckFilter filter = new LoginCheckFilter();
			filter.init(config);
			filter.doFilter(request, response, filterChain);

			assertTrue(LoginManager.getInstance().isLoggedIn(id));
			LoginManager.getInstance().remove(id);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.filter.LoginCheckFilter#destroy()} ̂߂̃eXgE\bhB
	 */
	public final void testDestroy() {
		try {
			LoginCheckFilter filter = new LoginCheckFilter();
			filter.destroy();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private void login() throws IOException {
		String urlStr = "http://localhost:8080/auth/SiteTransfer?TARGET=http%3A%2F%2Flocalhost%3A8080%2Fportal%2Ftop.jsp&termid=1&parent=parentAttribute&accountid=" + id;
		InputStream is = null;
		try {
			URL url = new URL(urlStr);
			HttpURLConnection con = (HttpURLConnection)url.openConnection();
			is = con.getInputStream();
			byte[] b = new byte[is.available()];
			is.read(b);
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch(Exception e) {
				}
			}
		}
	}

}
