//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisPreferenceController.m
//  Elis Colors
//
//  Created by 柳 on 09/09/26.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisPreferenceController.h"


@implementation ElisPreferenceController

- (id)init
{
    [NSBundle loadNibNamed:@"Preference" owner:self];
    return self;
}

- (void)setMainWindow:(NSWindow *)w
{
    _mainWindow = w;
}

- (void)run
{
    if(usingStampMode)
        [highPeformanceCheck setState:NSOnState];
    else
        [highPeformanceCheck setState:NSOffState];

    if(printBorderLine)
        [borderLineCheck setState:NSOnState];
    else
        [borderLineCheck setState:NSOffState];
    
    [NSApp beginSheet:_sheet modalForWindow:_mainWindow 
        modalDelegate:self didEndSelector:nil contextInfo:nil];    
}

- (IBAction)pushedOK:(id)sender
{
    usingStampMode = [highPeformanceCheck state];
    printBorderLine = [borderLineCheck state];
    
    [_sheet close];
    [NSApp endSheet:_sheet];
}

- (IBAction)pushedCancel:(id)sender
{
    [_sheet close];
    [NSApp endSheet:_sheet];
}

@end
