/*
 * $Id: MainActivity.java 11 2011-08-20 22:48:31Z lailai $
 */

package net.lailai.android.english.word.learning;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity {
	/** Called when the activity is first created. */

	private static final String ENGLISH_WORD_FILE = "EnglishWord6000.csv";
	private static final int QUESTION_COUNT = 6000;
	private static final int QUESTION_RANGE = 500;
	private static final int ANSWER_ACTIVITY = 0;
	private TextView QNo = null;
	private Button Score = null;
	private TextView QJa = null;
	private TextView Arrow = null;
	private TextView A = null;
	private TextView B = null;
	private TextView C = null;
	private TextView D = null;
	private TextView E = null;
	private Button ShowA = null;
	private int number = 0;
	private boolean nextQuestionflag = false;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		try {
			if (EnglishWord.getWordCount() == QUESTION_COUNT) {
				nextQuestionflag = false;
			} else {
				nextQuestionflag = true;
			}
			EnglishWord.clearWord();
			PlayData.setContext(this);
			loadEnglishWord();
			loadPreference();
		} catch (IOException e) {
			Log.e("English", "error");
		}
		setContentView(R.layout.question);

		showNextQuestion();

		ShowA.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, AnswerActivity.class);
				intent.putExtra("QUESTION_NO", String.valueOf(number));
				startActivityForResult(intent, ANSWER_ACTIVITY);
			}
		});

		// у{^
		Score = (Button)findViewById(R.id.button1);
		Score.setText("");
		Score.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, ScoreActivity.class);
				intent.putExtra("QUESTION_NO", String.valueOf(number));
				startActivity(intent);
			}
		});

	}

	private void showNextQuestion() {
		int range;
		if (PlayData.getDataSize() >= QUESTION_RANGE) {
			range = QUESTION_RANGE;
		} else {
			range = PlayData.getDataSize();
		}
		if (range != 0) {
			if (nextQuestionflag) {
				number = PlayData.getData((int)(Math.random() * range)).intValue();
				PlayData.setCurrentQuestion(number);
			} else {
				number = PlayData.getCurrentQuestion();
				nextQuestionflag = true;
			}
		} else {
			number = -1;
		}

		// ʂԍ
		QNo = (TextView)findViewById(R.id.textView1);
		QNo.setText("");

		// 
		QJa = (TextView)findViewById(R.id.textView2);
		QJa.setTextSize(40.0f);
		QJa.setText("ݏoł肪܂");

		// 
		Arrow = (TextView)findViewById(R.id.textView3);
		Arrow.setTextSize(40.0f);
		Arrow.setText("");

		// `Ȃ
		A = (TextView)findViewById(R.id.textView4);
		A.setTextSize(20.0f);
		A.setText("");
		B = (TextView)findViewById(R.id.textView5);
		B.setTextSize(20.0f);
		B.setText("");
		C = (TextView)findViewById(R.id.textView6);
		C.setTextSize(20.0f);
		C.setText("");
		D = (TextView)findViewById(R.id.textView7);
		D.setTextSize(20.0f);
		D.setText("");
		E = (TextView)findViewById(R.id.textView8);
		E.setTextSize(20.0f);
		E.setText("");

		// 
		ShowA = (Button)findViewById(R.id.button2);
		ShowA.setText("");
		ShowA.setEnabled(false);

		if (number != -1) {
			QNo.setText(String.valueOf(number) + ".");
			QJa.setText(EnglishWord.getJa(String.valueOf(number)));
			Arrow.setText("");
			String[] hints = EnglishWord.getHint(String.valueOf(number));
			int hints_no;
			if (hints == null) {
				hints_no = 0;
			} else {
				hints_no = hints.length;
			}
			A.setText(hints_no >= 1 ? hints[0] + "Ȃ" : "");
			B.setText(hints_no >= 2 ? hints[1] + "Ȃ" : "");
			C.setText(hints_no >= 3 ? hints[2] + "Ȃ" : "");
			D.setText(hints_no >= 4 ? hints[3] + "Ȃ" : "");
			E.setText(hints_no >= 5 ? hints[4] + "Ȃ" : "");
			ShowA.setEnabled(true);
		}
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onActivityResult(int, int, android.content.Intent)
	 */
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		switch (requestCode) {
		case ANSWER_ACTIVITY:
			if (resultCode == RESULT_OK) {
				PlayData.setScore(number - 1, String.valueOf(Integer.parseInt(PlayData.getScore(number - 1)) + 1));
				SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this);
				Editor ed = sp.edit();
				ed.putString(String.valueOf(number), PlayData.getScore(number - 1));
				ed.commit();
				if (PlayData.getScore(number - 1).equals("2")) {
					PlayData.removeData(PlayData.getDataIndex(new Integer(number)));
				}
			}
			showNextQuestion();
			break;
		default:
			break;	
		}
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.menu, menu);
		return true;
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);
		switch (item.getItemId()) {
		case R.id.clear:
			clearPreference();
			return true;
		case R.id.exit:
			moveTaskToBack(true);
		default:
			break;
		}
		return false;
	}

	private void loadEnglishWord() throws IOException {
		// P꒠ǂݍ
		AssetManager as = getResources().getAssets();
		InputStream is = as.open(ENGLISH_WORD_FILE);
		InputStreamReader isr = new InputStreamReader(is, "Shift_JIS");
		BufferedReader br = new BufferedReader(isr);
		String[] token = null;
		String line = br.readLine();	// wb_ǂݔ΂
		int no = 1;
		while ((line = br.readLine()) != null) {
			token = line.split(",");
			if (token.length < 2) {
				continue;
			}
			EnglishWord.addNo(String.valueOf(no));
			EnglishWord.addJa(token[0]);
			EnglishWord.addEn(token[1]);
			String[] hint = null;
			if (token.length == 7) {
				hint = new String[5];
				hint[4] = token[6];
				hint[3] = token[5];
				hint[2] = token[4];
				hint[1] = token[3];
				hint[0] = token[2];
			}
			if (token.length >= 6) {
				hint = new String[4];
				hint[3] = token[5];
				hint[2] = token[4];
				hint[1] = token[3];
				hint[0] = token[2];
			}
			if (token.length == 5) {
				hint = new String[3];
				hint[2] = token[4];
				hint[1] = token[3];
				hint[0] = token[2];
			}
			if (token.length == 4) {
				hint = new String[2];
				hint[1] = token[3];
				hint[0] = token[2];
			}
			if (token.length == 3) {
				hint = new String[1];
				hint[0] = token[2];
			}
			EnglishWord.addHint(hint);
			no++;
		}
		br.close();
		isr.close();
		is.close();
	}

	private void loadPreference() {
		PlayData.clearData();
		SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);
		for (int i = 0; i < EnglishWord.getWordCount(); i++) {
			PlayData.setScore(i, sharedPreferences.getString(String.valueOf(i + 1), "0"));
			if (!PlayData.getScore(i).equals("2")) {
				PlayData.addData(new Integer(i + 1));
			}
		}
	}

	private void clearPreference() {
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this);
		Editor ed = sp.edit();
		for (int i = 0 ; i < EnglishWord.getWordCount(); i++) {
			ed.putString(String.valueOf(i + 1), "0");
		}
		ed.commit();
		loadPreference();
	}
}
