#ifndef EOS_BAYES_H
#define EOS_BAYES_H

typedef struct eosBayesDistribution {
	float min;
	float max;
	float delta;
	int   n;
	float* prob;
} eosBayesDistribution;

 
typedef struct eosBayes {
	int numDistribution;
	eosBayesDistribution* prior;
	eosBayesDistribution* posterior;

	int numLikelihood;
	eosBayesDistribution* likelihood;
} eosBayes;

extern void eosBayesInit(eosBayes* b, int numDistribution, int numLikelihood, int mode);
extern void eosBayesDistributionInit(eosBayes* b, int mode);
extern void eosBayesDistributionInit0(eosBayesDistribution* d, int mode);
extern void eosBayesEstimation(eosBayesDistribution* d, int mode);
extern void eosBayesWrite(FILE* fpt, eosBayesDistribution* d, int mode);

#endif /* EOS_BAYES_H */
