/*
# lmrcImageEdge : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : lmrcImageEdge 
# Attention
#   $Loccker$
#  	$State$ 
#
*/
/* $Log$ */
#include <stdio.h>
#include <stdlib.h>
#include "./lmrcImageEdge.h"

int 
lmrcImageIsEdge(mrcImage* bin, mrcImageParaTypeReal x, mrcImageParaTypeReal y, mrcImageParaTypeReal z, int neighbor, int mode)
{
	double data;
	double data1, data2, data3, data4, data5, data6, data7, data8;

	mrcPixelDataGet(bin, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);	

	if(fabs(data-1)<1e-6) {
		switch(neighbor) {
			case 8: {
				mrcPixelDataGet(bin, x-1, y-1, z, &data5, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data5)<1e-6) break;
				mrcPixelDataGet(bin, x-1, y+1, z, &data6, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data6)<1e-6) break;
				mrcPixelDataGet(bin, x+1, y-1, z, &data7, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data7)<1e-6) break;
				mrcPixelDataGet(bin, x+1, y+1, z, &data8, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data8)<1e-6) break;
			}
			case 4: {
				mrcPixelDataGet(bin, x-1, y, z, &data1, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data1)<1e-6) break;
				mrcPixelDataGet(bin, x+1, y, z, &data2, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data2)<1e-6) break;
				mrcPixelDataGet(bin, x, y-1, z, &data3, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data3)<1e-6) break;
				mrcPixelDataGet(bin, x, y+1, z, &data4, mrcPixelRePart, mrcPixelHowNearest);	
				if(fabs(data4)<1e-6) break;
				return 0; 
			}
			default: {
				fprintf(stderr, "Not supported Neighbor: %d\n", neighbor);
				exit(EXIT_FAILURE);
			}
		}
		return 1;
	} else {
		return 0;
	}
}

