/*
# molecularWeightCalc : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : molecularWeightCalc
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
//#include "Test.h"
#include "./pdb.h"
/*
Example:
typedef struct lmolecularWeightCalcInfo {
	float a;
	int   b;
} lmolecularWeightCalcInfo;

typedef enum lmolecularWeightCalcMode {
	a=0,
	b=1
} lmolecularWeightCalcMode;
*/

int
main(int argc, char* argv[]) 
{
	molecularWeightCalcInfo info;
	FILE* fptIn; 
	pdbFile pdb;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	
	fptIn = fopen(argv[1],"r");
	if(fptIn==NULL){
		fprintf(stderr,"Can not Open File!!\n");
		exit(EXIT_FAILURE);
	}

	if(strncmp(argv[1],".pdb",3)==0){
		fprintf(stderr,"%s:Input File Shoud be .pdb\n",argv[1]);
		exit(EXIT_FAILURE);
	}

	pdbFileRead(&pdb,fptIn,0);
	pdbMolecularWeightCalc(&pdb);

	fprintf(stdout,"Molecular Weight of %s = %f.\n",argv[1],pdb.MW);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
