#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      ).as(inFile::mrcImage    ) ] :Essential :Input\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      ).as(outFile::mrcImage   ) ] :Essential :Output\n");
    fprintf(stderr, "    [-Shape              Shape               (NULL      ).as(outFile::mrcImage   ) ] :Optional  :Output\n");
    fprintf(stderr, "    [-r[adius]           minR                (3         ).as(Integer             ) \n                         maxR                (5         ).as(Integer             ) \n                         delR                (1         ).as(Integer             ) ] :Optional  :Radius[pixel]\n");
    fprintf(stderr, "    [-l[ength]           minL                (3         ).as(Integer             ) \n                         maxL                (5         ).as(Integer             ) \n                         delL                (1         ).as(Integer             ) ] :Optional  :Length[pixel]\n");
    fprintf(stderr, "    [-Phi                minPhi              (0.0       ).as(Real                ) \n                         maxPhi              (359.0     ).as(Real                ) \n                         delPhi              (1.0       ).as(Real                ) ] :Optional  :around z-axis[degree]\n");
    fprintf(stderr, "    [-Theta              minTheta            (0.0       ).as(Real                ) \n                         maxTheta            (359.0     ).as(Real                ) \n                         delTheta            (1.0       ).as(Real                ) ] :Optional  :around x-axis[degree]\n");
    fprintf(stderr, "    [-Psi                minPsi              (0.0       ).as(Real                ) \n                         maxPsi              (0.0       ).as(Real                ) \n                         delPsi              (90.0      ).as(Real                ) ] :Optional  :around x-axis[degree]\n");
    fprintf(stderr, "    [-thres[Zscore]      thresZscore         (1.0       ).as(Real                ) ] :Optional  :Zscore\n");
    fprintf(stderr, "    [-interp[olationMode]interpMode          (0         ).as(Integer             ) ] :Optional  :interpMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      ).as(inFile              ) ] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         ).as(Integer             ) ] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
