/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% eosBayesDistributionInit ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : eosBayesDistributionInit 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%eosBayesDistributionInit ver%I%; Date:%D% %Z%";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../inc/eosBayes.h"



void eosBayesDistributionInit(eosBayesDistribution* d, eosBayesDistributionInfo* info, int mode){

	int i;
	
	d->min   = info->min;
	d->max   = info->max;
	d->delta = info->delta;
	d->n     = (int)(((info->max-info->min)/info->delta)+0.5);

	d->value = (float*)malloc(sizeof(float)*d->n);
	d->prob  = (float*)malloc(sizeof(float)*d->n);

	for(i=0;i<d->n;i++){
		d->value[i] = d->min+(d->delta*i);
	}

	if(mode==0){
		info->mode = eosBayesDistributionInfoModeGaussian;
	}

	
}
