#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../inc/config.h"
#include "genUtil.h"
#include "String.h"
#include "File.h"
#include "Memory.h"


void
argCheck(mrcImagePrintInfo* info, int argc, char* argv[])
{
    long i;
    char s[1024];
    FILE* fpt;
    
    if(NULL==(fpt=fopen(".EosLog", "a+"))) { 
        
    } else {
        for(i=0; i<argc; i++) {
            fprintf(fpt, "%s ", argv[i]);
        }
        fprintf(fpt, "\n");
        fclose(fpt);
    }
    for(i=1; i<argc; i++) {
        if(OPTION_FLAG==argv[i][OPTION_FLAG_POS]) {
            SSWITCH(argv[i]+OPTION_POS)
                SCASE("i") {
                    if(i+1<argc) {
                        info->In = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagIn++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("o") {
                    if(i+1<argc) {
                        info->Out = stringGetNthWord(argv[i+1], 1, " ,");
                        i++;
                        info->flagOut++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("H") {
                    if(i+1<argc) {
                        info->thresHigh = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagthresHigh++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("L") {
                    if(i+1<argc) {
                        info->thresLow = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagthresLow++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("Section") {
                    if(i+1<argc) {
                        info->section = argv[i+1][0];
                        i++;
                        info->flagsection++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("x") {
                    if(i+2<argc) {
                        info->xMin = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagxMin++;
                        info->xMax = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagxMax++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("y") {
                    if(i+2<argc) {
                        info->yMin = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagyMin++;
                        info->yMax = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagyMax++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("z") {
                    if(i+2<argc) {
                        info->zMin = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagzMin++;
                        info->zMax = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagzMax++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("S") {
                    if(i+1<argc) {
                        info->Scale = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagScale++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("AS") {
                    if(i+1<argc) {
                        info->AbScale = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagAbScale++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("E") {
                    if(i+1<argc) {
                        info->Enlarge = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagEnlarge++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("center") {
                    if(i+2<argc) {
                        info->cx = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagcx++;
                        info->cy = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagcy++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("C") {
                    if(i+1<argc) {
                        {
                        int j, nv, check, count, nitem;
                        nv    = argc - i - 1;
                        nitem = 1 ;
                        check = nv%nitem ;
                        count = nv/nitem ;
                        if(0!=check) { fprintf(stderr, "Variable Number is strange. The number must be %d-times. nv: %d i\n", nitem, nv); usage(argv[0]); exit(EXIT_FAILURE);} 
                        info->contourLevel = (float*)memoryAllocate(sizeof(float)*count, "in argCheck");
                        for(j=0; j<count; j++) {
                            info->contourLevel[j] = stringGetNthRealData(argv[i+j*nitem+1], 1, " ,");
                        }
                        i++;
                        info->flagcontourLevel=count;
                        }
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("I") {
                    if(i+0<argc) {
                        info->Inverse++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("A") {
                    if(i+0<argc) {
                        info->Auto++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("AC") {
                    if(i+1<argc) {
                        info->AutoContour = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagAutoContour++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("PC") {
                    if(i+1<argc) {
                        info->PeakContour = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagPeakContour++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("AC2") {
                    if(i+1<argc) {
                        info->AutoContour2 = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagAutoContour2++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("Y") {
                    if(i+1<argc) {
                        info->Yexpand = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagYexpand++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("RGB") {
                    if(i+3<argc) {
                        info->Red = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagRed++;
                        info->Green = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagGreen++;
                        info->Blue = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBlue++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("RGBGradient") {
                    if(i+6<argc) {
                        info->RedFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagRedFirst++;
                        info->GreenFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagGreenFirst++;
                        info->BlueFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBlueFirst++;
                        info->RedLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagRedLast++;
                        info->GreenLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagGreenLast++;
                        info->BlueLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBlueLast++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("HSB") {
                    if(i+3<argc) {
                        info->Hue = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagHue++;
                        info->Saturation = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagSaturation++;
                        info->Brightness = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBrightness++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("HSBGradient") {
                    if(i+6<argc) {
                        info->HueFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagHueFirst++;
                        info->SaturationFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagSaturationFirst++;
                        info->BrightnessFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBrightnessFirst++;
                        info->HueLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagHueLast++;
                        info->SaturationLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagSaturationLast++;
                        info->BrightnessLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagBrightnessLast++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineColourRGB") {
                    if(i+3<argc) {
                        info->LineRed = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineRed++;
                        info->LineGreen = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineGreen++;
                        info->LineBlue = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBlue++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineColourRGBGradient") {
                    if(i+6<argc) {
                        info->LineRedFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineRedFirst++;
                        info->LineGreenFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineGreenFirst++;
                        info->LineBlueFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBlueFirst++;
                        info->LineRedLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineRedLast++;
                        info->LineGreenLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineGreenLast++;
                        info->LineBlueLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBlueLast++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineColourHSB") {
                    if(i+3<argc) {
                        info->LineHue = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineHue++;
                        info->LineSaturation = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineSaturation++;
                        info->LineBrightness = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBrightness++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineColourHSBGradient") {
                    if(i+6<argc) {
                        info->LineHueFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineHueFirst++;
                        info->LineSaturationFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineSaturationFirst++;
                        info->LineBrightnessFirst = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBrightnessFirst++;
                        info->LineHueLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineHueLast++;
                        info->LineSaturationLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineSaturationLast++;
                        info->LineBrightnessLast = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineBrightnessLast++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineChange") {
                    if(i+1<argc) {
                        info->LineColorChange = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineColorChange++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineWidthStart") {
                    if(i+1<argc) {
                        info->LineWidthStart = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineWidthStart++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("LineWidthStep") {
                    if(i+1<argc) {
                        info->LineWidthStep = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagLineWidthStep++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("ReverseOrder") {
                    if(i+0<argc) {
                        info->ReverseOrder++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("Untwist") {
                    if(i+1<argc) {
                        info->untwist = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flaguntwist++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("UpsideDown") {
                    if(i+0<argc) {
                        info->UpsideDown++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("Centre") {
                    if(i+0<argc) {
                        info->Centre++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("CircleRadius") {
                    if(i+1<argc) {
                        info->CircleRadius = stringGetNthRealData(argv[i+1], 1, " ,");
                        i++;
                        info->flagCircleRadius++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("m") {
                    if(i+1<argc) {
                        info->mode = stringGetNthIntegerData(argv[i+1], 1, " ,");
                        i++;
                        info->flagmode++;
                    } else {
                        usage(argv[0]);
                        exit(EXIT_FAILURE);
                    }
                    SBREAK;
                }
                SCASE("h") {
                    usage(argv[0]);
                    exit(EXIT_SUCCESS);
                    break;
                }
                SCASE("html") {
                    htmlBeforeUsage(argv[0]);
                    usage(argv[0]);
                    htmlAfterUsage(argv[0]);
                    exit(EXIT_SUCCESS);
                    break;
                }
                SDEFAULT {
                    fprintf(stderr, "Not Supported Options: :%s\n", argv[i]);
                    usage(argv[0]);
                    exit(EXIT_FAILURE);
                    break;
                }
            SSWITCHEND;
        } 
    } 
} 
