/*
# mrcImageAreaCalc : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageAreaCalc
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "lmrcImageCalcArea.h"

/*
Example:
typedef struct lmrcImageAreaCalcInfo {
	float a;
	int   b;
} lmrcImageAreaCalcInfo;

typedef enum lmrcImageAreaCalcMode {
	a=0,
	b=1
} lmrcImageAreaCalcMode;
*/

int
main(int argc, char* argv[]) 
{
	mrcImageAreaCalcInfo info;
	mrcImage in;
	mrcImage label;
	mrcImage out;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	mrcFileRead(&in, info.In, "mrcFileRead", 0);
	
	lmrcImageCalcArea(&out, &label, &in, 0);

	mrcFileWrite(&out, info.Out, "mrcFileWrite", 0);
	if(info.flagLabel) {
		mrcFileWrite(&label, info.Label, "mrcFileWrite", 0);
	}
	fprintf(info.fptOutInfo, "MaxRegion: %f \n", out.HeaderAMax);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
