/*
# mrcImageShapeSearch : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageShapeSearch
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "Memory.h"
#include "Matrix3D.h"
#include "Vector.h"
#include "mrcImage.h"

typedef struct lmrcImageShapeSearchInfo {
	float radius; // Sylinder, plane
	float minRadius;
	float maxRadius;
	float delRadius;

	float length; // Sylinder
	float minLength;
	float maxLength;
	float delLength;

	float thickness; // Plane
	float minThickness;
	float maxThickness;
	float delThickness;

	float minTheta;
	float maxTheta;
	float delTheta;

	float minPhi;
	float maxPhi;
	float delPhi;

	float minPsi;
	float maxPsi;
	float delPsi;

	int interpMode;
	mrcImage shape; // Template Structure 

	// Output
	mrcImage average; // Average for all orientations
	mrcImage SD;      // SD for all 
	mrcImage Zscore;  // Z-score;
	mrcImage shapeInfo; // Shape, Orientation, ... 
} lmrcImageShapeSearchInfo;

typedef enum lmrcImageShapeSearchMode {
	lmrcImageShapeSearchModeSylinder=0,
	lmrcImageShapeSearchModePlane=1
} lmrcImageShapeSearchMode;

extern void	lmrcImageShapeSearch(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode);
extern void	lmrcImageShapeSearchSylinder(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode);
extern void lmrcImageShapeSearchModePrint(FILE* fpt);

int
main(int argc, char* argv[]) 
{
	mrcImageShapeSearchInfo info;
	lmrcImageShapeSearchInfo linfo;
	mrcImage in;
	mrcImage out;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	linfo.minRadius = info.minR;
	linfo.maxRadius = info.maxR;
	linfo.minLength = info.minL;
	linfo.maxLength = info.maxL;

	linfo.minPhi   = info.minPhi*RADIAN;
	linfo.maxPhi   = info.maxPhi*RADIAN;
	linfo.delPhi   = info.delPhi*RADIAN;
	linfo.minTheta = info.minTheta*RADIAN;
	linfo.maxTheta = info.maxTheta*RADIAN;
	linfo.delTheta = info.delTheta*RADIAN;

	mrcFileRead(&in, info.In, "in main", 0); 

	lmrcImageShapeSearch(&out, &in, &linfo, info.mode);

	mrcFileWrite(&out, info.Out, "in main", 0);
	mrcFileWrite(&linfo.shape, info.Shape, "in main", 0);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
	lmrcImageShapeSearchModePrint(stderr);
}

void
lmrcImageShapeSearchModePrint(FILE* fpt)
{
	fprintf(fpt, "%d: Cylinder with radius and length\n", lmrcImageShapeSearchModeSylinder);
	fprintf(fpt, "%d: Plane with radius and thickness\n", lmrcImageShapeSearchModePlane);
}


void
lmrcImageShapeSearch(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode)
{
	switch(mode) {
		case lmrcImageShapeSearchModeSylinder: {
			lmrcImageShapeSearchSylinder(out, in, linfo, mode);
			break;
		}
		case lmrcImageShapeSearchModePlane: {
			lmrcImageShapeSearchPlane(out, in, linfo, mode);
			break;
		}
		default: {
			fprintf(stderr, "Not supported mode: %d\n", mode);
			break;
		}
	}
}


void
lmrcImageShapeSearchSylinder(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode)
{
	float x, y, z;
	float srcx, srcy, srcz;
	float dstx, dsty, dstz;
	float theta, phi, psi, radius, length;
	int iPhi, iTheta, iPsi, iRadius, iLength;	
	int nPhi, nTheta, nPsi, nRadius, nLength;	
	float max;
	double* data;
	double  d, cp, sp;
	double score;
	int nData, index;
	float r, l, p;
	Matrix3D mat;
	floatVector v;

	nPhi   = (int)((linfo->maxPhi     - linfo->minPhi)  /linfo->delPhi)  +1;
	nTheta = (int)((linfo->maxTheta   - linfo->minTheta)/linfo->delTheta)+1;
	nPsi= (int)((linfo->maxTheta   - linfo->minTheta)/linfo->delTheta)+1;
	nRadius = (int)((linfo->maxRadius - linfo->minRadius)/linfo->delRadius) + 1;
	nLength = (int)((linfo->maxLength - linfo->minLength)/linfo->delLength) + 1;
	
	nData = nPhi*nTheta*nPsi*nRadius*nLength;
	data = (double*)memoryAllocate(sizeof(double)*nData, "in lmrcImageShapeSearchSylinder");

	floatVectorInit(&v, 4);
	v.data[3] = 1;	

	for(z=0; z<in->HeaderN.z; z++) {
	for(y=0; y<in->HeaderN.y; y++) {
	for(x=0; x<in->HeaderN.x; x++) {
		for(iPhi=0; iPhi<nPhi; iPhi++) {	
			phi = linfo->minPhi + iPhi*linfo->delPhi;
		for(iTheta=0; iTheta<nTheta; iTheta++) {	
			theta = linfo->minTheta + iTheta*linfo->delTheta;
		for(iPsi=0; iPsi<nPsi; iPsi++) {	
			psi= linfo->minPsi+ iPhi*linfo->delPsi;
	
			matrix3DRotationSetFollowingEulerAngle(mat, "ZENS", phi, theta, psi, MATRIX_3D_MODE_INITIALIZE);

		for(iRadius=linfo->minRadius; iRadius<=linfo->maxRadius; iRadius++) {
			radius = linfo->minRadius + iRadius*linfo->delRadius;  
		for(iLength=linfo->minLength; iLength<=linfo->maxLength; iLength++) {
			length = linfo->minLength + iLength*linfo->delLength;  

			index = iPhi
				   +iTheta *nPhi
				   +iPsi   *nPhi*nTheta
				   +iRadius*nPhi*nTheta*nPsi
				   +iLength*nPhi*nTheta*nPsi*nRadius;

			score = 0; 
			for(p=0; r<2*M_PI;  l+=linfo->delPsi) {
				cp = cos(p);
				sp = sin(p);
			for(l=0; r<=length; l+=linfo->delLength) {
				v.data[2] = l-length/2; 
			for(r=0; r<=radius; r+=linfo->delRadius) {
				v.data[0] = r*cp;
				v.data[1] = r*sp;

				matrix3DMultiplyVector(&v, mat);
				dstx = x + v.data[0];
				dsty = y + v.data[1];
				dstz = z + v.data[2]; 
				mrcPixelDataGet(in, dstx, dsty, dstz, &d, mrcPixelRePart, linfo->interpMode);
				score += d;
			}
			v.data[0] = r*cos(p);
			v.data[1] = r*sin(p);
			matrix3DMultiplyVector(&v, mat);
			dstx = x + v.data[0];
			dsty = y + v.data[1];
			dstz = z + v.data[2]; 
			mrcPixelDataGet(in, dstx, dsty, dstz, &d, mrcPixelRePart, linfo->interpMode);
			score -= d;
			}
			}
			data[index] = score;
		}
		}
		}
		}
		}
		sum = 0;	
		for(i=0; i<nData; i++) {	
			sum += data[i];
		}
		ave = sum/nData;
		sum = 0;
		for(i=0; i<nData; i++) {	
			sum += SQR(data[i]-ave);
		}
		sd = sqrt(sum/nData);
	}
	}
	}
}

void
lmrcImageShapeSearchPlane(mrcImage* out, mrcImage* in, lmrcImageShapeSearchInfo* linfo, int mode)
{
}

