##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Project Edit dialog
#===========================================

proc dialog-project:CreateDialog {parent project} {
#---------------------------------------------------
    global dlgdata
    set this [dialog:CreateTabDialog $parent "dialog-project" Cancel Ok]
    if {![winfo exists $this]} {
        return ""
    }

    wm geometry $this 600x320+300+200
    wm minsize $this 600 320
    wm title $this "Settings for [main:DocDispatch GetDocData $project title]"

    set id [main:GetWindowId $this]
    set dlgdata($id,project) $project

    dialog-project:CreateFilesPage $this Files
    dialog-project:CreateGeneralPage $this General
    dialog-project:CreateBuildPage $this DebBuild
    dialog-project:CreateBuildPage $this RelBuild
    dialog-project:CreateDebugPage $this Debug
    dialog-project:CreateToolsPage $this Tools
    dialog-project:CreateTypesPage $this Types

    dialog:ActivateTabPage $this Files
    dialog:CenterDialog $this
    return $this
}

proc dialog-project:CreateFilesPage {this name} {
#---------------------------------------------------
    set page [dialog:CreateTabPage $this $name]

    frame  $page.f1 -borderwidth 1 -height 1 -relief flat -width 30 
    listbox $page.f1.list -height 1 -relief sunken  -borderwidth 1 -yscrollcommand "$page.f1.yscroll set" \
        -font [main:GetMainData font def]
    scrollbar $page.f1.yscroll -orient vertical -relief ridge -command "$page.f1.list yview"

    frame  $page.f2 -borderwidth 1 -height 20 -relief flat -width 30 
    button $page.f2.add_file -padx 9 -pady 1 -text {Add...} -width 10 -command "main:DlgDispatch OnAddFile $this $page.f1.list"
    button $page.f2.add_dir -padx 9 -pady 1 -text {Add Dir...} -width 10 -command "main:DlgDispatch OnAddDir $this $page.f1.list"
    button $page.f2.remove -padx 9 -pady 1 -text Remove -width 10 -command "main:DlgDispatch OnRemoveFile $this $page.f1.list"

    pack $page.f2 -anchor center -expand 0 -fill y -side right
    pack $page.f2.add_file -anchor center -expand 0 -fill none -padx 10 -pady 10 -side top
    pack $page.f2.add_dir -anchor center -expand 0 -fill none -padx 10 -pady 10 -side top
    pack $page.f2.remove -anchor center -expand 0 -fill none -padx 10 -pady 10 -side top

    pack $page.f1 -anchor center -expand 1 -fill both -side left
    pack $page.f1.list -expand 1 -fill both -side left
    pack $page.f1.yscroll -fill y -side right
}

proc dialog-project:CmnCreateEntryPage {this name num} {
#---------------------------------------------------------
    set page [dialog:CreateTabPage $this $name]
    set fnt [main:GetMainData font def]
    for {set i 0} {$i < $num} {incr i} {
        frame  $page.f$i -borderwidth 1 -height 1 -relief flat -width 30 
        label  $page.f$i.l -anchor w -relief flat -width 20
        entry  $page.f$i.ent -relief ridge -font "$fnt"
        pack $page.f$i -anchor center -expand 1 -fill x -side top 
        pack $page.f$i.l -anchor center -expand 0 -fill none -padx 5 -side left 
        pack $page.f$i.ent  -anchor center -expand 1 -fill x -side right 
    }
    return $page
}

proc dialog-project:CreateGeneralPage {this name} {
#---------------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog-project:CmnCreateEntryPage $this $name 6]
    $page.f0.l configure -text {Std libraries}
    $page.f1.l configure -text {Assembler flags}
    $page.f2.l configure -text {Compiler flags}
    $page.f3.l configure -text {Archiver flags}
    $page.f4.l configure -text {Linker flags}
    $page.f5.l configure -text {Dependencies}

    frame  $page.f6 -borderwidth 1 -height 1 -relief flat -width 30 
    checkbutton  $page.f6.path_mode -anchor w -relief flat -width 15 -text {Save project using absolute file paths} -variable dlgdata($id,path_mode)
    pack $page.f6 -anchor center -expand 1 -fill x -side top 
    pack $page.f6.path_mode -anchor center -expand 1 -fill x -padx 5 -side left 
}

proc dialog-project:CreateBuildPage {this name} {
#---------------------------------------------------
    set page [dialog-project:CmnCreateEntryPage $this $name 7]
    $page.f0.l configure -text {Target name}
    $page.f1.l configure -text {Output path}
    $page.f2.l configure -text {Object path}
    $page.f3.l configure -text {Assembler flags}
    $page.f4.l configure -text {Compiler flags}
    $page.f5.l configure -text {Archiver flags}
    $page.f6.l configure -text {Linker flags}
}

proc dialog-project:CreateDebugPage {this name} {
#---------------------------------------------------
    set page [dialog-project:CmnCreateEntryPage $this $name 4]
    $page.f0.l configure -text {Debugger}
    $page.f1.l configure -text {Program}
    $page.f2.l configure -text {Start-up dir}
    $page.f3.l configure -text {Arguments}
}

proc dialog-project:CreateToolsPage {this name} {
#---------------------------------------------------
    set page [dialog-project:CmnCreateEntryPage $this $name 4]
    $page.f0.l configure -text {Assembler}
    $page.f1.l configure -text {Compiler}
    $page.f2.l configure -text {Archiver}
    $page.f3.l configure -text {Linker}
}

proc dialog-project:CreateTypesPage {this name} {
#---------------------------------------------------
    set page [dialog-project:CmnCreateEntryPage $this $name 4]
    $page.f0.l configure -text {Files to assemble}
    $page.f1.l configure -text {Files to compile}
    $page.f2.l configure -text {Archives}
    $page.f3.l configure -text {Object files}
}

proc dialog-project:OnInitDialog {this} {
#----------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set project $dlgdata($id,project)

    set page [dialog:GetTabPage $this Files]
    set contents [main:DocDispatch GetDocData $project contents]
    foreach name $contents {
        $page.f1.list insert end $name
    }

    set page [dialog:GetTabPage $this General]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project glob_stdlib]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project glob_as]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project glob_cc]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project glob_ar]
    $page.f4.ent insert end [main:DocDispatch GetDocData $project glob_link]
    $page.f5.ent insert end [main:DocDispatch GetDocData $project glob_depgen]
    set dlgdata($id,path_mode) [main:DocDispatch GetDocData $project glob_pathmode]

    set page [dialog:GetTabPage $this DebBuild]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project deb_name]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project deb_out]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project deb_obj]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project deb_as]
    $page.f4.ent insert end [main:DocDispatch GetDocData $project deb_cc]
    $page.f5.ent insert end [main:DocDispatch GetDocData $project deb_ar]
    $page.f6.ent insert end [main:DocDispatch GetDocData $project deb_link]

    set page [dialog:GetTabPage $this RelBuild]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project rel_name]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project rel_out]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project rel_obj]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project rel_as]
    $page.f4.ent insert end [main:DocDispatch GetDocData $project rel_cc]
    $page.f5.ent insert end [main:DocDispatch GetDocData $project rel_ar]
    $page.f6.ent insert end [main:DocDispatch GetDocData $project rel_link]

    set page [dialog:GetTabPage $this Debug]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project debug_dbg]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project debug_exe]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project debug_start]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project debug_args]

    set page [dialog:GetTabPage $this Tools]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project as]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project cc]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project ar]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project link]

    set page [dialog:GetTabPage $this Types]
    $page.f0.ent insert end [main:DocDispatch GetDocData $project type_as]
    $page.f1.ent insert end [main:DocDispatch GetDocData $project type_cc]
    $page.f2.ent insert end [main:DocDispatch GetDocData $project type_ar]
    $page.f3.ent insert end [main:DocDispatch GetDocData $project type_obj]
}

proc dialog-project:DoAddFile {this lst filename} {
#---------------------------------------------------
    set page [dialog:GetTabPage $this Types]
    set type_ar [$page.f2.ent get]
    set type_make ".mak"

    if {[file isfile $filename]} {
        set contents [$lst get 0 end]
        set in [lsearch $contents $filename]
        if {$in < 0} {
            lappend contents $filename

            set sources ""
            set makes ""
            set libs ""
            foreach name $contents {
                set ext [file extension $name]
                if {$ext == $type_make} {
                    lappend makes $name
                } elseif {$ext == $type_ar} {
                    lappend libs $name
                } else {
                    lappend sources $name
                }
            }
            set contents [lsort $sources]
            foreach name [lsort $makes] {
                if {$name != ""} {
                    lappend contents $name
                }
            }
            foreach name $libs {
                if {$name != ""} {
                    lappend contents $name
                }
            }

            set in [lsearch $contents $filename]
            $lst delete 0 end
            foreach name $contents {
                if {$name != ""} {
                    $lst insert end $name
                }
            }
        }
        $lst selection clear 0 end
        $lst selection set $in
        $lst see $in
    }
}

proc dialog-project:OnAddFile {this lst} {
#---------------------------------------------------
    global tk_version
    if {$tk_version < 4.2} {
        set filename [tk_filesel $this.filesel -title "Add file"]
    } else {
        set filename [tk_getOpenFile -parent $this -title "Add file"]
    }
    if {$filename != ""} {
        dialog-project:DoAddFile $this $lst $filename
    }
}

proc dialog-project:OnAddDir {this lst} {
#---------------------------------------------------
    global tk_version
    if {$tk_version < 4.2} {
        set filename [tk_filesel $this.filesel -title "Add directory"]
    } else {
        set filename [tk_getOpenFile -parent $this -title "Add directory"]
    }
    if {$filename != ""} {
        set ext [file extension $filename]
        set dir [file dirname $filename]
        set filelist [glob -nocomplain $dir/*$ext]
        foreach filename $filelist {
            dialog-project:DoAddFile $this $lst $filename
        }
    }
}

proc dialog-project:OnRemoveFile {this lst} {
#---------------------------------------------------
    $lst delete active
    set in [$lst index active]
    $lst selection clear 0 end
    $lst selection set $in
    $lst see $in
}

proc dialog-project:OnOK {this} {
#-----------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set project $dlgdata($id,project)

    set page [dialog:GetTabPage $this Files]
    main:DocDispatch SetDocData $project contents [$page.f1.list get 0 end]

    set page [dialog:GetTabPage $this General]
    main:DocDispatch SetDocData $project glob_stdlib [$page.f0.ent get]
    main:DocDispatch SetDocData $project glob_as     [$page.f1.ent get]
    main:DocDispatch SetDocData $project glob_cc     [$page.f2.ent get]
    main:DocDispatch SetDocData $project glob_ar     [$page.f3.ent get]
    main:DocDispatch SetDocData $project glob_link   [$page.f4.ent get]
    main:DocDispatch SetDocData $project glob_depgen [$page.f5.ent get]
    main:DocDispatch SetDocData $project glob_pathmode $dlgdata($id,path_mode)

    set page [dialog:GetTabPage $this DebBuild]
    main:DocDispatch SetDocData $project deb_name [$page.f0.ent get]
    main:DocDispatch SetDocData $project deb_out  [$page.f1.ent get]
    main:DocDispatch SetDocData $project deb_obj  [$page.f2.ent get]
    main:DocDispatch SetDocData $project deb_as   [$page.f3.ent get]
    main:DocDispatch SetDocData $project deb_cc   [$page.f4.ent get]
    main:DocDispatch SetDocData $project deb_ar   [$page.f5.ent get]
    main:DocDispatch SetDocData $project deb_link [$page.f6.ent get]

    set page [dialog:GetTabPage $this RelBuild]
    main:DocDispatch SetDocData $project rel_name [$page.f0.ent get]
    main:DocDispatch SetDocData $project rel_out  [$page.f1.ent get]
    main:DocDispatch SetDocData $project rel_obj  [$page.f2.ent get]
    main:DocDispatch SetDocData $project rel_as   [$page.f3.ent get]
    main:DocDispatch SetDocData $project rel_cc   [$page.f4.ent get]
    main:DocDispatch SetDocData $project rel_ar   [$page.f5.ent get]
    main:DocDispatch SetDocData $project rel_link [$page.f6.ent get]

    set page [dialog:GetTabPage $this Debug]
    main:DocDispatch SetDocData $project debug_dbg   [$page.f0.ent get]
    main:DocDispatch SetDocData $project debug_exe   [$page.f1.ent get]
    main:DocDispatch SetDocData $project debug_start [$page.f2.ent get]
    main:DocDispatch SetDocData $project debug_args  [$page.f3.ent get]

    set page [dialog:GetTabPage $this Tools]
    main:DocDispatch SetDocData $project as        [$page.f0.ent get]
    main:DocDispatch SetDocData $project cc        [$page.f1.ent get]
    main:DocDispatch SetDocData $project ar        [$page.f2.ent get]
    main:DocDispatch SetDocData $project link      [$page.f3.ent get]

    set page [dialog:GetTabPage $this Types]
    main:DocDispatch SetDocData $project type_as   [$page.f0.ent get]
    main:DocDispatch SetDocData $project type_cc   [$page.f1.ent get]
    main:DocDispatch SetDocData $project type_ar   [$page.f2.ent get]
    main:DocDispatch SetDocData $project type_obj  [$page.f3.ent get]

    dialog:OnOK $this
}
