##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Global variables and initialization
#===========================================

global docdata

#===========================================
#	doc core
#===========================================

proc doc:OnCreateClient {this} {
#---------------------------------
}

proc doc:OnNewDocument {this} {
#---------------------------------
    global docdata
    set id [main:GetWindowId $this]
    set docdata($id,modified) false
}

proc doc:OnOpenDocument {this filename} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    set docdata($id,modified) false
}

proc doc:OnSaveDocument {this filename} {
#--------------------------------------------
}

proc doc:SaveIfModified {this {query 1}} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    set dirty [main:DocDispatch GetDocData $this modified]
    if {$dirty} {
        if {$query} {
            set title [main:DocDispatch GetDocData $this title]
            mdiclient:OnWindowActivate $title
            set ret [dialog:MessageBox $this $title "Document is modified\nDo you want to save it?" "Cancel-No-Yes"]
        } else {
            set ret "yes"
        }
        if {$ret == "cancel"} {
            return false
        }
        if {$ret == "yes"} {
            return [main:DoSaveDocument $this]
        }
    }
    return true
}

proc doc:OnCloseDocument {this} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    foreach name [array names docdata "$id,*"] {
        unset docdata($name)
    }
}

proc doc:OnChangeAppearance {this} {
#-----------------------------------------
}

proc doc:RenameDocument {this filename} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    if {$filename != ""} {
        set docdata($id,title) $filename
        set docdata($id,path) $filename
    } else {
        set docdata($id,title) "Untitled-$id"
        set docdata($id,path) ""
    }
    if {$docdata($id,modified) == "true"} {
        set docdata($id,title) "*$docdata($id,title)"
    }
}

proc doc:GetDocData {this which} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    if {[info exists docdata($id,$which)]} {
        return $docdata($id,$which)
    }
    return ""
}

proc doc:SetDocData {this which data} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    if {$which == "modified"} {
        main:DocDispatch SetModified $this $data
    } else {
        set docdata($id,$which) $data
    }
}

proc doc:SetModified {this {data true}} {
#--------------------------------------------
    global docdata
    set id [main:GetWindowId $this]
    if {$docdata($id,modified) != $data} {
        main:DocInWindowMenu $this remove
        set docdata($id,modified) $data
        main:DocInWindowMenu $this add [main:DocDispatch GetDocData $this path]
    }
}
