///////////////////////////////////////////////////////////
//  CalibrateModel.cpp
//  Implementation of the Class CalibrateModel
//  Created on:      12-7-2009 9:29:43
//  Original author: m-inui
///////////////////////////////////////////////////////////

#include "CalibrateModel.h"




CalibrateModel::CalibrateModel(char (*dispData)[DISP_HEIGHT]):m_ObservCnt(0){
	m_CalibrateData.m_DispData = dispData;
}


CalibrateModel::~CalibrateModel(){

}


CalibrateData CalibrateModel::getData(){
	return  m_CalibrateData;
}


void CalibrateModel::notify(){
	m_View->update();
	m_Controller->update();
}


void CalibrateModel::setData(CalibrateData calibrateData){
	m_CalibrateData = calibrateData;
}


void CalibrateModel::set(Observer* observer){
	if(m_ObservCnt==0){
		m_Controller = observer;
		m_ObservCnt++;
	}
	else if(m_ObservCnt==1){
		m_View = observer;
		m_ObservCnt++;
	}
}



void CalibrateModel::service(){
	notify();
}
