///////////////////////////////////////////////////////////
//  MenuModel.cpp
//  Implementation of the Class MenuModel
//  Created on:      12-7-2009 9:29:43
//  Original author: m-inui
///////////////////////////////////////////////////////////

#include "MenuModel.h"
#include "Test.h"

MenuModel::MenuModel(char (*dispData)[DISP_HEIGHT]): m_ObservCnt(0){
	m_MenuData.m_DispData = dispData;
}


MenuModel::~MenuModel(){

}


MenuData MenuModel::getData(){
	return m_MenuData;
}


void MenuModel::notify(){
	m_View->update();
	m_Controller->update();
}


void MenuModel::setData(MenuData menuData){
	m_MenuData = menuData;
}




void MenuModel::set(Observer* observer){
	if(m_ObservCnt==0){
		m_Controller = observer;
		m_ObservCnt++;
	}
	else if(m_ObservCnt==1){
		m_View = observer;
		m_ObservCnt++;
	}
}



void MenuModel::service(){
	notify();
}

