///////////////////////////////////////////////////////////
//  PID.cpp
//  Implementation of the Class PID
//  Created on:      11-7-2009 20:33:37
//  Original author: m-usami
///////////////////////////////////////////////////////////

#include "PID.h"

const F32 PID::KD;
const F32 PID::KP_WIDTH;

/**
 * RXgN^
 * 	l̐ݒ
 */
PID::PID(LightSensorValue &bb) :
	ControlAlgorithm(bb), kpWidth_(KP_WIDTH), kd_(KD),
	m_preLight(0), m_velocity(VELOCITY) {
}

/**
 * fXgN^
 */
PID::~PID() {
}

/**
 * 
 * 	臒l肷
 */
void PID::init() {
	F32 black = blackboard_.getBlack();
	F32 gray  = blackboard_.getGray();
	F32 white = blackboard_.getWhite();
	kpWidth_  = blackboard_.getP();
	kd_       = -1 * blackboard_.getD();
	m_velocity = blackboard_.getSpeed();

	threashold_ = ((gray + white) / 2);
	upper_ = threashold_ + (((black - white) * kpWidth_)/ 2);
	lower_ = threashold_ - (((black - white) * kpWidth_)/ 2);
	kp_    = ((MAX - MIN) / ((black - white) * kpWidth_));
}

/**
 * PID̖{
 * 	Ƒx̗𐧌
 */
void PID::getCommand(S16 light, S8& direction, S8& velocity){
	direction = getDirectionCommand(light);
	velocity = getVelocityCommand(light);
}

/* pPID̖{
 * 	ZT[l͂Đʂo͂
 * 	ZT[lƐʂ̌^̓ZT[l̒l͈͂ƘAȂĂ悢
 * 	A_ŕŝI/F APǏ^ƈv
 */
S8 PID::getDirectionCommand(S16 light){
	if (light > upper_) {
		light = static_cast<S16>(upper_);
	}
	else if (light < lower_) {
		light = static_cast<S16>(lower_);
	}
	S8 direction = edge_ * static_cast<S8>(kp_ * (threashold_ - light)
				- kd_ * (m_preLight - light));
	blackboard_.setDirection(direction);

	m_preLight = light;
	return direction;
}

/**
 * 臒liPID̖ڕWlj̎擾
 */
F32 PID::getThreashold() {
	return threashold_;
}

/**
 * 臒liPID̖ڕWlj̐ݒ
 */
void PID::setThreashold(F32 threashold) {
	threashold_ = threashold;
}

/**
 * x̐ݒi0`100j
 */
void PID::setVelocity(S8 velocity) {
	m_velocity = velocity;
}

/**
 * x̖{
 * 	Ƃ肠萔l
 */
S8 PID::getVelocityCommand(S16 light) {
	return forward_ * m_velocity;
}
