///////////////////////////////////////////////////////////
//  RallyDriver.cpp
//  Implementation of the Class RallyDriver
//  Created on:      11-7-2009 18:13:38
//  Original author: Administrator
///////////////////////////////////////////////////////////

#include "RallyDriver.h"
#include "ControlFactory.h"
#include "TouchStarter.h"

extern ControlFactory	factoryControl;

RallyDriver::RallyDriver() : id_(END_OF_DTechID) {
}


RallyDriver::~RallyDriver() {
}

void RallyDriver::setNavigator(Navigator* pNavi) {
	m_pNavigator = pNavi;
}

void RallyDriver::execute() {
	S8 dataS08[2] = {0};
	S32 dataS32 = 0;
	
	IControl* updateControl = factoryControl.getControl(IControl::BLACKBOARD_CONTROLLER);
	// IControl* runControl = factoryControl.getControl(IControl::RALLY_DRIVER);

	for( ; ; ) {
		// IɋNB
		waitHeartBeat();
		
		// LZĂI邽߂̏B
		if (isCanceled()) {
			// I邽߂̏BE͏ԂŒ~B
			rightMotor.setBrake(false);
			leftMotor.setBrake(false);
			
			// Lݒ肵Ȃƃ[^[͒~ȂB
			rightMotor.reset();
			leftMotor.reset();
			
			// [v𔲂BiʑŊʒmBj
			break;
		}
		
		updateControl->execute();		// ubN{[hXV
		drive(m_pNavigator->getDTech());	// s
		if (bt.isConnected()) {
			daq.send(dataS08, dataS32);// BT logging
		}
	}
}

void RallyDriver::drive(DTechID id) {
	if (id_ != id) {
		id_ = id;
		drTech[id_]->init();
	}
	drTech[id_]->drive();
}

void RallyDriver::setDTech(DTechID id, IDTech* tech) {
	if ((id < 0) || (id >= MAX_DTechID)) {
		return;
	}
	drTech[id] = tech;
}

void RallyDriver::ready(){
	// {RunMenuɈڂāAp(BT)ƋZp(BTȂ)ŕI
	CHAR  name[16];
	U8 address[7];
	if (bt.getDeviceAddress(address)) {
		lcd.putf("sn", "BD_ADDR:");
		for(SINT i=0; i<7; i++) lcd.putf("x", address[i],2); 
		if (bt.getFriendlyName(name)) {
			lcd.putf("nss", "BD_NAME: ", name);
		}
		lcd.putf("nsn", "Connecting BT...");
		lcd.disp();
		//winconnect
		if(bt.waitForConnection("1234", 5000)) { // wait 5sec
			lcd.putf("sn", "Connected BT");
		} else {
			lcd.putf("sn", "Not Connected BT");
		}
	}
//	S8 dataS08[2] = {0};
//	S32 dataS32 = 0;
	// ecrobot::Daq daq(bt);

	lcd.putf("sn", "touch on white.");
	lcd.disp();
	TouchStarter(touch).waitForReadyGo();
	S32 tmp = 0;
	for(S8 i = 0; i < 10; i++) {
		tmp += lightsensor.get();
		clock.wait(50);
	}
	tmp /= 10;
	blackboard.setWhite((S16)tmp);
	lcd.clear();
	lcd.putf("sn", "touch on white.");
	lcd.putf("dn", blackboard.getWhite(), 4);

	lcd.putf("sn", "touch on black.");
	lcd.disp();
	TouchStarter(touch).waitForReadyGo();
	tmp = 0;
	for(S8 i = 0; i < 10; i++) {
		tmp += lightsensor.get();
		clock.wait(50);
	}
	tmp /= 10;
	blackboard.setBlack((S16)tmp);
	lcd.putf("dn", blackboard.getBlack(), 4);

	lcd.putf("sn", "touch on gray.");
	lcd.disp();
	TouchStarter(touch).waitForReadyGo();
	tmp = 0;
	for(S8 i = 0; i < 10; i++) {
		tmp += lightsensor.get();
		clock.wait(50);
	}
	tmp /= 10;
	blackboard.setGray((S16)tmp);
	lcd.putf("dn", blackboard.getGray(), 4);
	lcd.putf("sn", "touch to cls.");
	lcd.disp();
	TouchStarter(touch).waitForReadyGo();
	for(S8 i = 0; i < 10; i++) {
		tmp += lightsensor.get();
		clock.wait(50);
	}
}


