//
// t@C : Boot.cpp
//
//	Tv      : e^XNNB
//				t@Ng̃CX^X𐶐iO[o錾j
//				
//

// TaskUI
#include "UIFactory.h"
#include "IMenu.h"

// TaskRallyControl
#include "ControlFactory.h"
#include "IControl.h"

#include "Globals.h"
#include "BlackBoardData.h"

#include "kernel.h"
#include "kernel_id.h"

#include "TouchStarter.h"

#include "AbstractU32BlackBoard.h"

extern "C"
{

//------------------------------------------------
// j[Ip̉

extern const TaskType TaskUI;
extern const TaskType TaskHeartBeat;
extern const TaskType TaskInitialize;
extern const TaskType TaskUserOperation;
extern const TaskType TaskRunControl;
extern const TaskType PollingUiTask;
extern const TaskType PollingRunTask;

extern const EventMaskType EV_UI_HEARTBEAT;
extern const EventMaskType EV_USER_OPERATION;
extern const EventMaskType EV_CONTROL_START_RALLY;
extern const EventMaskType EV_CONTROL_COMPLETE;
extern const EventMaskType EV_CONTROL_CANCEL;
extern const EventMaskType EV_RUN_HEARTBEAT;
extern const EventMaskType EV_INIT_COMPLETED;


DeclareCounter(SysTimerCnt);
DeclareTask(PollingRunTask);
DeclareTask(PollingUiTask);
DeclareTask(TaskUI);
DeclareTask(TaskHeartBeat);
DeclareTask(TaskInitialize);
DeclareTask(PollingTouchTask);
DeclareTask(TaskRunControl);

//=============================================================================
// foCXIuWFNg̐
UIFactory	factoryUI;
ControlFactory	factoryControl;

// PollingTouchTask̏ԁB
static U16 statePollingTouchTask ;

enum
{
	ST_INIT, 		// ҂
	ST_PUSH_ON1,	// 1ڂ̉mF
	ST_PUSH_ON2,	// 2ڂ̉mF
	ST_PUSH_OFF,	// OFFmF
};

// BlackBoardFactory	factoryBlackBoard;


//=============================================================================
// ֐	: user_1ms_isr_type2
// 		: Ȃ
// ߂l	: Ȃ
// Tv		: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//
//  烊NG[ɂȂ̂ŁAԂKvB
void user_1ms_isr_type2(void)
{
	StatusType ercd;
	
	/* ALARM gƂɁAL̐ݒ肪ȂƎNłȂB
	 * http://codezine.jp/article/detail/3703?p=2 Ă܂ꂽI
	 *  Increment OSEK Alarm System Timer Count
     */
	ercd = SignalCounter( SysTimerCnt );
	if( ercd != E_OK ){
		ShutdownOS( ercd );
	}

	SleeperMonitor(); // ClockNX܂I2CfoCXNXgpɕKv
}


//=============================================================================
// ^XN	: TaskInitialize
// Tv		: p̃^XN
//


TASK(TaskInitialize)
{
	statePollingTouchTask = ST_INIT;
	
	// N݂̐̂s^XNB
	factoryUI.create();
	factoryControl.create();

//	factoryBlackBoard.create();

// BlackBoardǵAt@NgoāAgetter/setterŃANZX
// BlackBoard *blackboard = factoryBlackBoard.get();
// blackboard->getLightSensorWhite();
// blackboard->setLightSensorWhite(100);

	// e^XNNB
	// ŃAʃCN邱ƁB

	// sJnƏ҂
	ActivateTask( TaskRunControl );
	WaitEvent( EV_INIT_COMPLETED );
	ClearEvent( EV_INIT_COMPLETED );
	
	// sJnƏ҂
	ActivateTask( TaskUI );
	WaitEvent( EV_INIT_COMPLETED );
	ClearEvent( EV_INIT_COMPLETED );
	
	// sJnƏ҂
	// ActivateTask( TaskUserOperation );
	// WaitEvent( EV_INIT_COMPLETED );
	// ClearEvent( EV_INIT_COMPLETED );
	
	// ^XNI
	TerminateTask() ; // ꖳŋNƁAAṽZbgɂȂB
}


//=============================================================================
// ^XN	: UITask
// Tv		: User Interface ^XN
//


void DispMainMenuSelect( )
{
                          //1234567890123456
	char	selectText[17]="                ";
	
	selectText[(int)(factoryUI.getID() * 2 + 1)] = '@';
	
	lcd.putf("sn", selectText );
	
}

void DispMainMenu( )
{
	lcd.clear();
	DispMainMenuSelect( );
//	lcd.putf("sn", " R R L P G ");
//	lcd.putf("sn", " u u i I y ");
//	lcd.putf("sn", " n n g D r ");
//	lcd.putf("sn", "   | h | o ");
//	lcd.putf("sn", "   S t S   ");
//	lcd.putf("sn", "   e   e   ");
//	lcd.putf("sn", "   t   t   ");
	lcd.putf("sn", " R R L P G ");
	lcd.putf("sn", " u u");
	lcd.putf("sn", " n n");
	lcd.putf("sn", "   |");
	lcd.putf("sn", "   S");
	lcd.putf("sn", "   e");
	lcd.putf("sn", "   t");
	lcd.disp();
}


TASK(TaskUI)
{	
	U8 nowMenuNo = DEFAULT_MAIN_MENU; // ʕ\̂߃ftHglZbgB

	// vONɉE{^ŋN̂ŁAP񕪉Eɐił܂̂hB
	for(;;)
	{
		clock.sleep(100);
		
		if( Nxt::RUN_ON  != nxt.getButtons())
		{
			break;
		}
	}

	// ^XNN̕
	SetEvent( TaskInitialize, EV_INIT_COMPLETED );
	
	for(;;)
	{
		if( nowMenuNo != factoryUI.getID() )
		{
			// ʍXVΕ\B
			DispMainMenu();
			
			nowMenuNo = factoryUI.getID();
		}
		
	
		// {^B
		if(Nxt::ENTR_ON  == nxt.getButtons())
		{
			// IĂ郁j[sB
			lcd.putf("s", "EntBottonOn:");
			lcd.putf("dn", nowMenuNo );
			lcd.disp();
			clock.sleep(500);
			for(;;)
			{
				clock.sleep(100);
				
				if( Nxt::ENTR_ON  != nxt.getButtons())
				{
					lcd.clear();
					break;
				}
			}
			
			factoryUI.disp();
			
			nowMenuNo = DEFAULT_MAIN_MENU;
		}
		// E{^B
		else if( Nxt::RUN_ON  == nxt.getButtons())
		{
			factoryUI.next();

			for(;;)
			{
				clock.sleep(100);
				
				if( Nxt::RUN_ON  != nxt.getButtons())
				{
					break;
				}
			}
		}
	}
	
	// ^XNI
	TerminateTask() ;

}



//=============================================================================
// ^XN	: TaskRallyControl
// Tv		: RallyiZsjRg[쓮p^XN
//

TASK(TaskRunControl)
{	
	IControl* runControl = factoryControl.getControl(IControl::RALLY_DRIVER);

	// ^XNN̕
	SetEvent( TaskInitialize, EV_INIT_COMPLETED );
	

	for(;;)
	{
		// X^[gCxgsJnB
		runControl->waitStart(	TaskRunControl,
									TaskUI,
									EV_CONTROL_START_RALLY ,	// ̃Cxg͂̃^XNNpB
									EV_CONTROL_CANCEL,			// ȉ́AėpB
									EV_CONTROL_COMPLETE,		// 
									EV_RUN_HEARTBEAT );		// 
	}

	
	// ^XNI
	TerminateTask() ;
}


// [U[B
TASK(PollingTouchTask)
{
	
	TouchStarter startSw( touch );
	
	switch(	statePollingTouchTask )
	{
		case ST_INIT:
			if( startSw.isPressed())
			{
				statePollingTouchTask = ST_PUSH_ON1;
			}
			break;
			
		case ST_PUSH_ON1:
			if( startSw.isPressed())
			{
				// ONCxg𔭍s
				SetEvent( TaskUI, EV_USER_OPERATION );

				statePollingTouchTask = ST_PUSH_ON2;
			}
			else
			{
				statePollingTouchTask = ST_INIT;
			}
			break;

		case ST_PUSH_ON2:
			if( !startSw.isPressed()) // OFF҂B
			{
				statePollingTouchTask = ST_PUSH_OFF;
			}
			break;

		case ST_PUSH_OFF:
			if( !startSw.isPressed()) // OFF҂B
			{
				statePollingTouchTask = ST_INIT;
			}
			break;

		default:
			statePollingTouchTask = ST_INIT;
			break;
	}
	
	// ^XNI
	TerminateTask() ;
}

TASK(PollingRunTask)
{
	SetEvent( TaskRunControl, EV_RUN_HEARTBEAT );

	// ^XNI
	TerminateTask() ;

}


TASK(PollingUiTask)
{
	
	SetEvent( TaskUI, EV_UI_HEARTBEAT );

	// ^XNI
	TerminateTask() ;

}




};	// extern C


