///////////////////////////////////////////////////////////
//  IDTech.h
//  Implementation of the Class IDTech
//  Created on:      11-7-2009 20:33:34
//  Original author: Administrator
///////////////////////////////////////////////////////////

#if !defined(EA_EE26F378_DEF3_40c1_8E1E_428A285561E1__INCLUDED_)
#define EA_EE26F378_DEF3_40c1_8E1E_428A285561E1__INCLUDED_

#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "ecrobot_types.h"
#include "LightSensorValue.h"

extern "C"
{
	#include "balancer.h"
}

class IDTech
{
//private:
protected:
	static const U16 USER_GYRO_OFFSET = 595;
	const ecrobot::Nxt& m_Nxt;
	const ecrobot::GyroSensor& m_GyroSensor;
	ecrobot::Motor& m_LeftMotor;
	ecrobot::Motor& m_RightMotor;

	U16 m_GyroSensorOffset;

protected:
	LightSensorValue& m_BlackBoard;		// BlackBoardmf[^x[X

	S8 m_Direction;
	S8 m_Velocity;
	S8 m_LeftMotorPWM;
	S8 m_RightMotorPWM;

	virtual void balance();		// p balance_controllerĂ

public:
	IDTech(const ecrobot::Nxt& nxt, const ecrobot::GyroSensor& gyro,
			ecrobot::Motor& leftMotor, ecrobot::Motor& rightMotor,
			LightSensorValue& bb);
	virtual ~IDTech();

	virtual void init();
	virtual void drive();		// hCu̎Ԃ͌pŎ

};
#endif // !defined(EA_EE26F378_DEF3_40c1_8E1E_428A285561E1__INCLUDED_)
