///////////////////////////////////////////////////////////
//  LineTraceLeftDTech.cpp
//  Implementation of the Class LineTraceLeftDTech
//  Created on:      11-7-2009 20:33:33
//  Original author: Administrator
///////////////////////////////////////////////////////////

#include "LineTraceLeftDTech.h"


LineTraceLeftDTech::LineTraceLeftDTech(const ecrobot::Nxt& nxt,
		const ecrobot::GyroSensor& gyro, ecrobot::Motor& leftMotor,
		ecrobot::Motor& rightMotor, LightSensorValue& bb,
		ControlAlgorithm& algorithm) :
			IDTech(nxt, gyro, leftMotor, rightMotor, bb), 
			m_Algorithm(algorithm) {
}


LineTraceLeftDTech::~LineTraceLeftDTech(){
}

/**
 * s̏
 * 	GbWsݒ
 * 	Oiݒ
 */
void LineTraceLeftDTech::init() {
	m_Algorithm.init();
	m_Algorithm.leftEdge();
	m_Algorithm.forward();
}

/**
 * s̎s
 */
void LineTraceLeftDTech::drive() {
	// ZT[l𓾂
	m_Light = m_BlackBoard.inspect();
	// lƑxl𓾂
	m_Algorithm.getCommand(m_Light, m_Direction, m_Velocity);
	// oXs
	balance();
}
