/*
 * Decompiled with CFR 0.152.
 */
package lejos.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import lejos.charset.CharsetDecoder;

public class LejosInputStreamReader
extends Reader {
    private static final int MIN_BUFFERSIZE = 16;
    private final CharsetDecoder coder;
    private final InputStream is;
    private final byte[] buffer;
    private int offset;
    private int limit;
    private char low;

    public LejosInputStreamReader(InputStream is, CharsetDecoder coder, int buffersize) {
        this.is = is;
        this.coder = coder;
        if (buffersize < 16) {
            buffersize = 16;
        }
        if (coder.getMaxCharLength() > buffersize) {
            throw new IllegalArgumentException("buffer to small for given charset");
        }
        this.buffer = new byte[buffersize];
    }

    public int fillBuffer() throws IOException {
        int len = this.limit - this.offset;
        int req = this.coder.estimateByteCount(this.buffer, this.offset, this.limit);
        if (len < req) {
            int tmp;
            int rem = this.buffer.length - this.offset;
            if (rem < this.coder.getMaxCharLength()) {
                System.arraycopy(this.buffer, this.offset, this.buffer, 0, len);
                this.offset = 0;
                this.limit = len;
            }
            do {
                if ((tmp = this.is.read(this.buffer, this.limit, this.buffer.length - this.limit)) < 0) {
                    return len;
                }
                this.limit += tmp;
            } while ((len += tmp) < (req = this.coder.estimateByteCount(this.buffer, this.offset, this.limit)));
        }
        return req;
    }

    public int read() throws IOException {
        if (this.low > '\u0000') {
            char tmp = this.low;
            this.low = '\u0000';
            return tmp;
        }
        int needed = this.fillBuffer();
        if (needed <= 0) {
            return -1;
        }
        int cp = this.coder.decode(this.buffer, this.offset, this.limit);
        this.offset += needed;
        if (cp < 65536) {
            return cp;
        }
        this.low = (char)((cp -= 65536) & 0x3FF | 0xDC00);
        return cp >> 10 | 0xD800;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int needed;
        if (len < 1) {
            return 0;
        }
        int origoff = off;
        int endoff = off + len - 1;
        if (this.low > '\u0000') {
            cbuf[off++] = this.low;
            this.low = '\u0000';
            needed = this.coder.estimateByteCount(this.buffer, this.offset, this.limit);
        } else {
            needed = this.fillBuffer();
        }
        if (off < endoff) {
            while (this.limit - this.offset >= needed) {
                int cp = this.coder.decode(this.buffer, this.offset, this.limit);
                if (cp < 65536) {
                    cbuf[off++] = (char)cp;
                } else {
                    cbuf[off++] = (char)((cp >> 10) + 55296);
                    cbuf[off++] = (char)((cp & 0x3F) + 56320);
                }
                this.offset += needed;
                if (off >= endoff) break;
                needed = this.coder.estimateByteCount(this.buffer, this.offset, this.limit);
            }
        }
        return off - origoff;
    }

    public void close() throws IOException {
    }
}

