/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.USB;

public class USBConnection
extends NXTConnection {
    static final int HDRSZ = 1;
    private static final int CLOSETIMEOUT2 = 100;

    public USBConnection(int mode) {
        this.state = 4;
        this.bufSz = 64;
        this.inBuf = new byte[64];
        this.outBuf = new byte[64];
        this.is = null;
        this.os = null;
        this.setIOMode(mode);
    }

    int flushBuffer(boolean wait) {
        int len;
        if (this.outCnt <= 0) {
            return 1;
        }
        while ((len = USB.usbWrite(this.outBuf, 0, this.outCnt)) == 0 && wait && this.state >= 4) {
            try {
                this.wait(1L);
            }
            catch (Exception exception) {}
        }
        if (len <= 0) {
            return len;
        }
        this.outCnt = 0;
        return len;
    }

    int fillBuffer(boolean wait) {
        int cnt;
        if (this.inCnt > 0) {
            return this.inCnt;
        }
        while ((cnt = USB.usbRead(this.inBuf, 0, this.inBuf.length)) == 0 && wait && this.state >= 4) {
            try {
                this.wait(1L);
            }
            catch (Exception exception) {}
        }
        this.inOffset = 0;
        if (cnt > 0) {
            this.inCnt = cnt;
        }
        return cnt;
    }

    void disconnect() {
        USB.waitForDisconnect(this, 100);
        super.disconnect();
    }

    void freeConnection() {
        USB.usbDisable();
    }

    public void setIOMode(int mode) {
        if (mode == 0) {
            this.setHeader(1);
        } else {
            this.setHeader(0);
        }
    }
}

