/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.navigation;

import lejos.nxt.Battery;
import lejos.robotics.TachoMotor;
import lejos.robotics.navigation.Pilot;

public class TachoPilot
implements Pilot {
    protected final TachoMotor _left;
    protected final TachoMotor _right;
    protected final float _leftDegPerDistance;
    protected final float _rightDegPerDistance;
    protected final float _leftTurnRatio;
    protected final float _rightTurnRatio;
    protected float _robotMoveSpeed;
    protected float _robotTurnSpeed;
    protected int _motorSpeed;
    private byte _parity;
    private boolean _regulating = true;
    protected final float _trackWidth;
    protected final float _leftWheelDiameter;
    protected final float _rightWheelDiameter;

    public TachoPilot(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor) {
        this(wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public TachoPilot(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        this(wheelDiameter, wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public TachoPilot(float leftWheelDiameter, float rightWheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        this._left = leftMotor;
        this._leftWheelDiameter = leftWheelDiameter;
        this._leftTurnRatio = trackWidth / leftWheelDiameter;
        this._leftDegPerDistance = 360.0f / ((float)Math.PI * leftWheelDiameter);
        this._right = rightMotor;
        this._rightWheelDiameter = rightWheelDiameter;
        this._rightTurnRatio = trackWidth / rightWheelDiameter;
        this._rightDegPerDistance = 360.0f / ((float)Math.PI * rightWheelDiameter);
        this._trackWidth = trackWidth;
        this._parity = (byte)(reverse ? -1 : 1);
        this.setSpeed(360);
    }

    public TachoMotor getLeft() {
        return this._left;
    }

    public TachoMotor getRight() {
        return this._right;
    }

    public int getLeftCount() {
        return this._parity * this._left.getTachoCount();
    }

    public int getRightCount() {
        return this._parity * this._right.getTachoCount();
    }

    public int getLeftActualSpeed() {
        return this._left.getRotationSpeed();
    }

    public int getRightActualSpeed() {
        return this._right.getRotationSpeed();
    }

    public float getTurnRatio() {
        return (this._leftTurnRatio + this._rightTurnRatio) / 2.0f;
    }

    public void setSpeed(int speed) {
        this._motorSpeed = speed;
        this._robotMoveSpeed = (float)speed / Math.max(this._leftDegPerDistance, this._rightDegPerDistance);
        this._robotTurnSpeed = (float)speed / Math.max(this._leftTurnRatio, this._rightTurnRatio);
        this.setSpeed(speed, speed);
    }

    private void setSpeed(int leftSpeed, int rightSpeed) {
        this._left.regulateSpeed(this._regulating);
        this._left.smoothAcceleration(!this.isMoving());
        this._right.regulateSpeed(this._regulating);
        this._right.smoothAcceleration(!this.isMoving());
        this._left.setSpeed(leftSpeed);
        this._right.setSpeed(rightSpeed);
    }

    public void setMoveSpeed(float speed) {
        this._robotMoveSpeed = speed;
        this._motorSpeed = Math.round(0.5f * speed * (this._leftDegPerDistance + this._rightDegPerDistance));
        this.setSpeed(Math.round(speed * this._leftDegPerDistance), Math.round(speed * this._rightDegPerDistance));
    }

    public float getMoveSpeed() {
        return this._robotMoveSpeed;
    }

    public float getMoveMaxSpeed() {
        return Battery.getVoltage() * 100.0f / Math.max(this._leftDegPerDistance, this._rightDegPerDistance);
    }

    public void setTurnSpeed(float speed) {
        this._robotTurnSpeed = speed;
        this.setSpeed(Math.round(speed * this._leftTurnRatio), Math.round(speed * this._rightTurnRatio));
    }

    public float getTurnSpeed() {
        return this._robotTurnSpeed;
    }

    public float getTurnMaxSpeed() {
        return Battery.getVoltage() * 100.0f / Math.max(this._leftTurnRatio, this._rightTurnRatio);
    }

    public void forward() {
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        if (this._parity == 1) {
            this.fwd();
        } else {
            this.bak();
        }
    }

    public void backward() {
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        if (this._parity == 1) {
            this.bak();
        } else {
            this.fwd();
        }
    }

    public void rotate(float angle) {
        this.rotate(angle, false);
    }

    public void rotate(float angle, boolean immediateReturn) {
        this.setSpeed(Math.round(this._robotTurnSpeed * this._leftTurnRatio), Math.round(this._robotTurnSpeed * this._rightTurnRatio));
        int rotateAngleLeft = this._parity * (int)(angle * this._leftTurnRatio);
        int rotateAngleRight = this._parity * (int)(angle * this._rightTurnRatio);
        this._left.rotate(-rotateAngleLeft, true);
        this._right.rotate(rotateAngleRight, immediateReturn);
        if (!immediateReturn) {
            while (this._left.isMoving() || this._right.isMoving()) {
                Thread.yield();
            }
        }
    }

    public float getAngle() {
        return (float)this._parity * ((float)this._right.getTachoCount() / this._rightTurnRatio - (float)this._left.getTachoCount() / this._leftTurnRatio) / 2.0f;
    }

    public void stop() {
        this._left.stop();
        this._right.stop();
    }

    public boolean isMoving() {
        return this._left.isMoving() || this._right.isMoving();
    }

    public void reset() {
        this._left.resetTachoCount();
        this._right.resetTachoCount();
    }

    public float getTravelDistance() {
        float left = (float)this._left.getTachoCount() / this._leftDegPerDistance;
        float right = (float)this._right.getTachoCount() / this._rightDegPerDistance;
        return (float)this._parity * (left + right) / 2.0f;
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void travel(float distance, boolean immediateReturn) {
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        this._left.rotate((int)((float)this._parity * distance * this._leftDegPerDistance), true);
        this._right.rotate((int)((float)this._parity * distance * this._rightDegPerDistance), immediateReturn);
        if (!immediateReturn) {
            while (this._left.isMoving() || this._right.isMoving()) {
                Thread.yield();
            }
        }
    }

    public void steer(float turnRate) {
        this.steer(turnRate, Float.POSITIVE_INFINITY, true);
    }

    public void steer(float turnRate, float angle) {
        this.steer(turnRate, angle, false);
    }

    public void steer(float turnRate, float angle, boolean immediateReturn) {
        TachoMotor outside;
        TachoMotor inside;
        float rate = turnRate;
        if (rate < -200.0f) {
            rate = -200.0f;
        }
        if (rate > 200.0f) {
            rate = 200.0f;
        }
        if (rate == 0.0f) {
            if (angle < 0.0f) {
                this.backward();
            } else {
                this.forward();
            }
            return;
        }
        if (turnRate < 0.0f) {
            inside = this._right;
            outside = this._left;
            rate = -rate;
        } else {
            inside = this._left;
            outside = this._right;
        }
        outside.setSpeed(this._motorSpeed);
        float steerRatio = 1.0f - rate / 100.0f;
        inside.setSpeed((int)((float)this._motorSpeed * steerRatio));
        if (angle == 2.1474836E9f) {
            if (this._parity == 1) {
                outside.forward();
            } else {
                outside.backward();
            }
            if ((float)this._parity * steerRatio > 0.0f) {
                inside.forward();
            } else {
                inside.backward();
            }
            return;
        }
        float rotAngle = angle * this._trackWidth * 2.0f / (this._leftWheelDiameter * (1.0f - steerRatio));
        inside.rotate(this._parity * (int)(rotAngle * steerRatio), true);
        outside.rotate(this._parity * (int)rotAngle, immediateReturn);
        if (immediateReturn) {
            return;
        }
        while (inside.isMoving() || outside.isMoving()) {
            Thread.yield();
        }
        inside.setSpeed(outside.getSpeed());
    }

    public boolean stalled() {
        return 0 == this._left.getRotationSpeed() || 0 == this._right.getRotationSpeed();
    }

    private void bak() {
        this._left.backward();
        this._right.backward();
    }

    public void regulateSpeed(boolean yes) {
        this._regulating = yes;
        this._left.regulateSpeed(yes);
        this._right.regulateSpeed(yes);
    }

    private void fwd() {
        this._left.forward();
        this._right.forward();
    }

    public void arc(float radius) {
        this.steer(this.turnRate(radius));
    }

    public void arc(float radius, float angle) {
        this.steer(this.turnRate(radius), angle);
    }

    public void arc(float radius, float angle, boolean immediateReturn) {
        this.steer(this.turnRate(radius), angle, immediateReturn);
    }

    private float turnRate(float radius) {
        float radiusToUse;
        int direction;
        if (radius < 0.0f) {
            direction = -1;
            radiusToUse = -radius;
        } else {
            direction = 1;
            radiusToUse = radius;
        }
        float ratio = (2.0f * radiusToUse - this._trackWidth) / (2.0f * radiusToUse + this._trackWidth);
        return (float)(direction * 100) * (1.0f - ratio);
    }

    public void travelArc(float radius, float distance) {
        this.travelArc(radius, distance, false);
    }

    public void travelArc(float radius, float distance, boolean immediateReturn) {
        double angle = (double)(distance * 180.0f) / (Math.PI * (double)radius);
        this.arc(radius, (int)angle, immediateReturn);
    }
}

