/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.subsumption;

import lejos.robotics.subsumption.Behavior;

public class Arbitrator {
    private final int NONE = -1;
    private Behavior[] _behavior;
    private int _highestPriority = -1;
    private int _active = -1;
    private boolean _returnWhenInactive;
    private Monitor monitor;

    public Arbitrator(Behavior[] behaviorList, boolean returnWhenInactive) {
        this._behavior = behaviorList;
        this._returnWhenInactive = returnWhenInactive;
        this.monitor = new Monitor();
        this.monitor.setDaemon(true);
    }

    public Arbitrator(Behavior[] behaviorList) {
        this(behaviorList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.monitor.start();
        while (this._highestPriority == -1) {
            Thread.yield();
        }
        while (true) {
            Monitor monitor = this.monitor;
            synchronized (monitor) {
                if (this._highestPriority != -1) {
                    this._active = this._highestPriority;
                } else if (this._returnWhenInactive) {
                    this.monitor.more = false;
                    return;
                }
            }
            if (this._active != -1) {
                this._behavior[this._active].action();
                this._active = -1;
            }
            Thread.yield();
        }
    }

    private class Monitor
    extends Thread {
        boolean more = true;
        int maxPriority = Arbitrator.access$100(Arbitrator.this).length - 1;

        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.more) {
                Monitor monitor = this;
                synchronized (monitor) {
                    int active;
                    Arbitrator.this._highestPriority = -1;
                    for (int i = this.maxPriority; i >= 0; --i) {
                        if (!Arbitrator.this._behavior[i].takeControl()) continue;
                        Arbitrator.this._highestPriority = i;
                        break;
                    }
                    if ((active = Arbitrator.this._active) != -1 && Arbitrator.this._highestPriority > active) {
                        Arbitrator.this._behavior[active].suppress();
                    }
                }
                Thread.yield();
            }
        }
    }
}

