/*
 * Decompiled with CFR 0.152.
 */
package lejos.util;

import lejos.util.Matrix;

public class KalmanFilter {
    private Matrix a;
    private Matrix b;
    private Matrix c;
    private Matrix i;
    private Matrix q;
    private Matrix r;
    private Matrix at;
    private Matrix ct;
    private Matrix mu;
    private Matrix sigma;
    private Matrix muBar;
    private Matrix sigmaBar;
    private Matrix gain;

    public KalmanFilter(Matrix a, Matrix b, Matrix c, Matrix q, Matrix r) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.q = q;
        this.r = r;
        this.at = a.transpose();
        this.ct = c.transpose();
    }

    public void setState(Matrix mean, Matrix covariance) {
        this.mu = mean;
        this.sigma = covariance;
        int n = this.mu.getColumnDimension();
        this.i = Matrix.identity(n, n);
    }

    public void update(Matrix control, Matrix measurement) {
        this.muBar = this.a.times(this.mu).plus(this.b.times(control));
        this.sigmaBar = this.a.times(this.sigma).times(this.at).plus(this.r);
        this.gain = this.sigmaBar.times(this.ct).times(this.c.times(this.sigmaBar).times(this.ct).plus(this.q).inverse());
        this.mu = this.muBar.plus(this.gain.times(measurement.minus(this.c.times(this.muBar))));
        this.sigma = this.i.minus(this.gain.times(this.c)).times(this.sigmaBar);
    }

    public Matrix getMean() {
        return this.mu;
    }

    public Matrix getCovariance() {
        return this.sigma;
    }

    public Matrix getPredictedMean() {
        return this.muBar;
    }

    public Matrix getPredictedCovariance() {
        return this.sigmaBar;
    }

    public Matrix getGain() {
        return this.gain;
    }
}

