///////////////////////////////////////////////////////////
//  ControlAlgorithm.h
//  Implementation of the Class ControlAlgorithm
//  Created on:      11-7-2009 21:15:35
//  Original author: m-usami
///////////////////////////////////////////////////////////

#if !defined(EA_AE3A5A1E_556C_4671_9159_DB8ABF9095A7__INCLUDED_)
#define EA_AE3A5A1E_556C_4671_9159_DB8ABF9095A7__INCLUDED_

#include "ecrobot_types.h"
#include "LightSensorValue.h"

class ControlAlgorithm {
protected:
	static const S8 LEFT_EDGE = 1;
	static const S8 RIGHT_EDGE = -1;
	static const S8 FORWARD = 1;
	static const S8 BACKWARD = -1;
	S8 edge_;
	S8 forward_;

	LightSensorValue& blackboard_;
public:
	ControlAlgorithm(LightSensorValue& bb);
	virtual ~ControlAlgorithm();

	virtual void init();
	void leftEdge();
	void rightEdge();
	void forward();
	void backward();
	virtual void getCommand(S16 light, S8& direction, S8& velocity) {}
};
#endif // !defined(EA_AE3A5A1E_556C_4671_9159_DB8ABF9095A7__INCLUDED_)
