/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(Line2D line) {
        this.setLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return Line2D.linesIntersect(x1, y1, x2, y2, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(l.getX1(), l.getY1(), l.getX2(), l.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return Line2D.relativeCCW(x1, y1, x2, y2, x3, y3) * Line2D.relativeCCW(x1, y1, x2, y2, x4, y4) <= 0 && Line2D.relativeCCW(x3, y3, x4, y4, x1, y1) * Line2D.relativeCCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double tpx = px - x1;
        double ty = y2 - y1;
        double tpy = py - y1;
        double tx = x2 - x1;
        double ccw = tpx * ty - tpy * tx;
        if (ccw == 0.0 && (ccw = tpx * tx + tpy * ty) > 0.0 && (ccw = (tpx -= tx) * tx + (tpy -= ty) * ty) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public int relativeCCW(double px, double py) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public boolean intersects(Rectangle2D r) {
        return r.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static class Double
    extends Line2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double h;
            double y;
            double w;
            double x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }
    }

    public static class Float
    extends Line2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float h;
            float y;
            float w;
            float x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Float(x, y, w, h);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }
    }
}

