/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        double tx = x1 - x2;
        double ty = y1 - y2;
        return tx * tx + ty * ty;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point2D.distanceSq(x1, y1, x2, y2));
    }

    public double distanceSq(double px, double py) {
        double tx = px - this.getX();
        double ty = py - this.getY();
        return tx * tx + ty * ty;
    }

    public double distanceSq(Point2D pt) {
        return this.distanceSq(pt.getX(), pt.getY());
    }

    public double distance(double px, double py) {
        return Math.sqrt(this.distanceSq(px, py));
    }

    public double distance(Point2D pt) {
        return Math.sqrt(this.distanceSq(pt));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point2D) {
            Point2D p2d = (Point2D)obj;
            return this.getX() == p2d.getX() && this.getY() == p2d.getY();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Point2D.Double[" + this.x + ", " + this.y + "]";
        }
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Point2D.Float[" + this.x + ", " + this.y + "]";
        }
    }
}

