/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import lejos.charset.Latin1Encoder;
import lejos.io.LejosOutputStreamWriter;

public class BufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFERSIZE = 64;
    private static final int MIN_BUFFERSIZE = 1;
    private final Writer parent;
    private final char[] buffer;
    private int limit;

    @Deprecated
    public BufferedWriter(OutputStream os) {
        this(new LejosOutputStreamWriter(os, new Latin1Encoder(), 32));
    }

    public BufferedWriter(Writer out) {
        this(out, 64);
    }

    public BufferedWriter(Writer out, int size) {
        if (size < 1) {
            size = 1;
        }
        this.parent = out;
        this.buffer = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flushAny();
        }
        finally {
            this.parent.close();
        }
    }

    private void flushAny() throws IOException {
        if (this.limit > 0) {
            this.parent.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
    }

    private int flushFull() throws IOException {
        if (this.limit >= this.buffer.length) {
            this.parent.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        return this.buffer.length - this.limit;
    }

    public void flush() throws IOException {
        this.flushAny();
        this.parent.flush();
    }

    public void newLine() throws IOException {
        this.write(13);
        this.write(10);
    }

    public Writer append(CharSequence str, int start, int end) throws IOException {
        int len = end - start;
        while (len > 0) {
            int plen = this.flushFull();
            if (plen > len) {
                plen = len;
            }
            for (int i = 0; i < plen; ++i) {
                this.buffer[this.limit + i] = str.charAt(start + i);
            }
            len -= plen;
            start += plen;
            this.limit += plen;
        }
        return this;
    }

    public void write(char[] c, int off, int len) throws IOException {
        while (len > 0) {
            int plen = this.flushFull();
            if (plen > len) {
                plen = len;
            }
            System.arraycopy(c, off, this.buffer, this.limit, plen);
            len -= plen;
            off += plen;
            this.limit += plen;
        }
    }

    public void write(int c) throws IOException {
        this.flushFull();
        this.buffer[this.limit++] = (char)c;
    }

    public void write(String str, int off, int len) throws IOException {
        while (len > 0) {
            int plen = this.flushFull();
            if (plen > len) {
                plen = len;
            }
            str.getChars(off, off + plen, this.buffer, this.limit);
            len -= plen;
            off += plen;
            this.limit += plen;
        }
    }
}

