/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    private static final int INITIAL_CAPACITY = 10;
    private static final int CAPACITY_INCREMENT_NUM = 3;
    private static final int CAPACITY_INCREMENT_DEN = 2;
    protected byte[] buf;
    protected int count;

    public void ensureCapacity(int minCapacity) {
        int cl = this.buf.length;
        if (cl < minCapacity) {
            cl = cl * 3 / 2 + 1;
            while (cl < minCapacity) {
                cl = cl * 3 / 2 + 1;
            }
            byte[] newData = new byte[cl];
            System.arraycopy(this.buf, 0, newData, 0, this.count);
            this.buf = newData;
        }
    }

    public ByteArrayOutputStream() {
        this.buf = new byte[10];
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size is negative");
        }
        this.buf = new byte[size];
    }

    public void close() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] r = new byte[this.count];
        System.arraycopy(this.buf, 0, r, 0, this.count);
        return r;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Deprecated
    public String toString(int hibyte) {
        hibyte <<= 8;
        int c = this.count;
        char[] cbuf = new char[c];
        for (int i = 0; i < c; ++i) {
            cbuf[i] = (char)(this.buf[i] & 0xFF | hibyte);
        }
        return new String(cbuf);
    }

    public String toString(String charset) {
        return new String(this.buf, 0, this.count, charset);
    }

    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)b;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.count);
    }
}

