/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    public DataInputStream(InputStream in) {
        super(in);
    }

    private int readByte0() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch & 0xFF;
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte0() != 0;
    }

    public final byte readByte() throws IOException {
        return (byte)this.readByte0();
    }

    public final char readChar() throws IOException {
        int x = this.readByte0();
        x = x << 8 | this.readByte0();
        return (char)x;
    }

    public final double readDouble() throws IOException {
        long x = this.readLong();
        return Double.longBitsToDouble(x);
    }

    public final float readFloat() throws IOException {
        int x = this.readInt();
        return Float.intBitsToFloat(x);
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IOException();
        }
        while (len > 0) {
            int count = this.in.read(b, off, len);
            if (count < 0) {
                throw new EOFException();
            }
            off += count;
            len -= count;
        }
    }

    public final int readInt() throws IOException {
        int x = this.readByte0();
        x = x << 8 | this.readByte0();
        x = x << 8 | this.readByte0();
        x = x << 8 | this.readByte0();
        return x;
    }

    public final long readLong() throws IOException {
        long x = this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        x = x << 8 | (long)this.readByte0();
        return x;
    }

    public final short readShort() throws IOException {
        int x = this.readByte0();
        x = x << 8 | this.readByte0();
        return (short)x;
    }

    public final int readUnsignedByte() throws IOException {
        int x = this.readByte0();
        return x;
    }

    public final int readUnsignedShort() throws IOException {
        int x = this.readByte0();
        x = x << 8 | this.readByte0();
        return x;
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public final int skipBytes(int n) throws IOException {
        return (int)this.in.skip(n);
    }

    @Deprecated
    public final String readLine() throws IOException {
        StringBuilder strb = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.read()) < 0) {
                if (strb.length() != 0) break;
                return null;
            }
            if (c == 10) {
                int p = strb.length() - 1;
                if (p < 0 || strb.charAt(p) != '\r') break;
                return strb.substring(0, p);
            }
            strb.append((char)c);
        }
        return strb.toString();
    }
}

