/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int MAX_EXPONENT = 1023;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final int MIN_EXPONENT = -1022;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int SIZE = 64;
    public static final Class<?> TYPE = null;
    private double value;

    public Double(double val) {
        this.value = val;
    }

    public Double(String val) {
        this.value = Double.parseDouble(val);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)o).value);
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double val) {
        return val != val;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static double parseDouble(String s) throws NumberFormatException {
        return StringUtils.stringToDouble(s);
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(double d) {
        return String.valueOf(d);
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static Double valueOf(String s) {
        return new Double(s);
    }

    public static native long doubleToRawLongBits(double var0);

    public static long doubleToLongBits(double value) {
        long l = Double.doubleToRawLongBits(value);
        long m = l & Long.MAX_VALUE;
        if (m >= 9218868437227405313L && m <= Long.MAX_VALUE) {
            l = 9221120237041090560L;
        }
        return l;
    }

    public static native double longBitsToDouble(long var0);
}

