/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private static final int INITIAL_CAPACITY = 10;
    private static final int CAPACITY_INCREMENT_NUM = 3;
    private static final int CAPACITY_INCREMENT_DEN = 2;
    private int elementCount;
    private Object[] elementData;
    protected transient int modCount;

    public ArrayList() {
        this.elementCount = 0;
        this.elementData = new Object[10];
    }

    public ArrayList(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    public ArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity is negative");
        }
        this.elementCount = 0;
        this.elementData = new Object[initialCapacity];
    }

    @Deprecated
    public ArrayList(E[] elements) {
        this(elements.length * 13 / 10);
        this.addAll(elements);
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = element;
        ++this.elementCount;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = element;
        return true;
    }

    @Deprecated
    public void addAll(E[] elements) {
        int len = elements.length;
        if (len <= 0) {
            return;
        }
        this.ensureCapacity(this.elementCount + len);
        System.arraycopy(elements, 0, this.elementData, this.elementCount, len);
        this.elementCount += len;
    }

    @Deprecated
    public void addAll(int index, E[] elements) {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int len = elements.length;
        if (len <= 0) {
            return;
        }
        this.ensureCapacity(this.elementCount + len);
        System.arraycopy(this.elementData, index, this.elementData, index + len, this.elementCount - index);
        System.arraycopy(elements, 0, this.elementData, index, len);
        this.elementCount += len;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.elementCount, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int size = c.size();
        if (size <= 0) {
            return false;
        }
        this.ensureCapacity(this.elementCount + size);
        System.arraycopy(this.elementData, index, this.elementData, index + size, this.elementCount - index);
        Iterator<E> i = c.iterator();
        for (int j = 0; j < size; ++j) {
            this.elementData[index + j] = i.next();
        }
        this.elementCount += size;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int el = this.elementData.length;
        if (el < minCapacity) {
            el = el * 3 / 2 + 1;
            while (el < minCapacity) {
                el = el * 3 / 2 + 1;
            }
            Object[] newData = new Object[el];
            System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
            this.elementData = newData;
        }
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.elementData[index];
    }

    @Override
    public int indexOf(Object element) {
        if (element == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!element.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        if (element == null) {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (!element.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        Object element = this.elementData[index];
        System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - index - 1);
        this.elementData[--this.elementCount] = null;
        return (E)element;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    protected void removeRange(int start, int end) {
        if (start <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return;
        }
        ++this.modCount;
        int oldcount = this.elementCount;
        int newcount = oldcount - end + start;
        System.arraycopy(this.elementData, end, this.elementData, start, oldcount - end);
        for (int i = newcount; i < oldcount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = newcount;
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        Object o = this.elementData[index];
        this.elementData[index] = element;
        return (E)o;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new MyIterator(index);
    }

    @Override
    public List<E> subList(int start, int end) {
        throw new UnsupportedOperationException("subList not yet supported");
    }

    public void trimToSize() {
        if (this.elementCount < this.elementData.length) {
            ++this.modCount;
            Object[] newData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
            this.elementData = newData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements ListIterator<E> {
        private int modcount;
        private int lastpos = -1;
        private int nextpos;

        public MyIterator(int index) {
            this.nextpos = index;
            this.modcount = ArrayList.this.modCount;
        }

        private void checkModCount() {
            if (this.modcount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkLastPos() {
            if (this.lastpos < 0) {
                throw new IllegalStateException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < ArrayList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.nextpos > 0;
        }

        @Override
        public E next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastpos = this.nextpos++;
            return ArrayList.this.get(this.lastpos);
        }

        @Override
        public E previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastpos = --this.nextpos;
            return ArrayList.this.get(this.nextpos);
        }

        @Override
        public void remove() {
            this.checkLastPos();
            this.checkModCount();
            ArrayList.this.remove(this.lastpos);
            this.modcount = ArrayList.this.modCount;
            this.lastpos = -1;
        }

        @Override
        public void set(E e) {
            this.checkLastPos();
            this.checkModCount();
            ArrayList.this.set(this.lastpos, e);
        }

        @Override
        public void add(E e) {
            this.checkModCount();
            ArrayList.this.add(this.nextpos, e);
            this.modcount = ArrayList.this.modCount;
            this.lastpos = -1;
        }

        @Override
        public int nextIndex() {
            return this.nextpos;
        }

        @Override
        public int previousIndex() {
            return this.nextpos - 1;
        }
    }
}

