/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import lejos.nxt.comm.Bluetooth;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    private Connector() {
    }

    public static Connection open(String name) throws IOException {
        StreamConnectionNotifier c = null;
        String scheme = Connector.parseScheme(name);
        final String target = Connector.parseTarget(name);
        if (!scheme.equals("btspp")) {
            throw new ConnectionNotFoundException(scheme + " not a known protocol");
        }
        c = new StreamConnectionNotifier(){
            private StreamConnection sc = null;

            public StreamConnection acceptAndOpen() throws IOException {
                return Bluetooth.connect(target, 2);
            }

            public void close() throws IOException {
                if (this.sc != null) {
                    this.sc.close();
                }
            }
        };
        return c;
    }

    private static String parseScheme(String name) {
        int end = name.indexOf(58);
        return name.substring(0, end);
    }

    private static String parseTarget(String name) {
        int start = name.indexOf("://") + 3;
        int end = name.indexOf(59, start);
        if (end == -1) {
            end = name.length();
        }
        return name.substring(start, end);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        return Connector.open(name);
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        InputConnection ic = (InputConnection)Connector.open(name);
        return ic.openDataInputStream();
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        OutputConnection oc = (OutputConnection)Connector.open(name);
        return oc.openDataOutputStream();
    }

    public static InputStream openInputStream(String name) throws IOException {
        InputConnection ic = (InputConnection)Connector.open(name);
        return ic.openInputStream();
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        OutputConnection oc = (OutputConnection)Connector.open(name);
        return oc.openOutputStream();
    }
}

