/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import lejos.nxt.LCD;

public class Graphics {
    private static final int ARC_ACC = 5;
    public static final int BLACK = 1;
    public static final int WHITE = 0;
    public static final int SOLID = 0;
    public static final int DOTTED = 2;
    private int rgbColor = 1;
    private int strokeStyle = 0;
    private Font font = new Font();

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 64;
    }

    public int getCenteredX(String str) {
        return (16 - str.length()) * 6 / 2;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(int rgb) {
        this.rgbColor = rgb;
    }

    public int getColor() {
        return this.rgbColor;
    }

    public void setPixel(int rgbColor, int x, int y) {
        LCD.setPixel(rgbColor, x, y);
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        this.drawLine(x0, y0, x1, y1, this.strokeStyle);
    }

    private void drawLine(int x0, int y0, int x1, int y1, int style) {
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        boolean skip = false;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        if (style == 0 && (dy == 0 || dx == 0)) {
            LCD.bitBlt(stepx == 1 ? x0 : x1, stepy == 1 ? y0 : y1, dx == 0 ? 1 : dx + 1, dy == 0 ? 1 : dy + 1, this.rgbColor == 1 ? 255 : 0);
            return;
        }
        this.setPixel(this.rgbColor, x0, y0);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                x0 += stepx;
                fraction += dy;
                if (style == 0 || !skip) {
                    this.setPixel(this.rgbColor, x0, y0);
                }
                skip = !skip;
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                y0 += stepy;
                fraction += dx;
                if (style == 0 || !skip) {
                    this.setPixel(this.rgbColor, x0, y0);
                }
                skip = !skip;
            }
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, this.strokeStyle, false);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, 0, true);
    }

    private void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, int style, boolean fill) {
        int radius;
        int xscale = width < height ? 5 : (5 * width + (width >> 1)) / height;
        int yscale = width < height ? (5 * height + (height >> 1)) / width : 5;
        int x0 = x + (width >> 1);
        int y0 = y + (height >> 1);
        int n = radius = width < height ? width >> 1 : height >> 1;
        while (startAngle < 0) {
            startAngle += 360;
        }
        while (startAngle > 360) {
            startAngle -= 360;
        }
        while (arcAngle > 360) {
            arcAngle -= 360;
        }
        while (arcAngle < -360) {
            arcAngle += 360;
        }
        int endAngle = startAngle + arcAngle;
        if (arcAngle >= 0) {
            if (endAngle > 360) {
                this.drawTheArc(radius, style, fill, xscale, yscale, startAngle, 360, x0, y0);
                this.drawTheArc(radius, style, fill, xscale, yscale, 0, endAngle - 360, x0, y0);
            } else {
                this.drawTheArc(radius, style, fill, xscale, yscale, startAngle, endAngle, x0, y0);
            }
        } else if (endAngle < 0) {
            this.drawTheArc(radius, style, fill, xscale, yscale, endAngle + 360, 360, x0, y0);
            this.drawTheArc(radius, style, fill, xscale, yscale, 0, startAngle, x0, y0);
        } else {
            this.drawTheArc(radius, style, fill, xscale, yscale, endAngle, startAngle, x0, y0);
        }
    }

    private void drawTheArc(int radius, int style, boolean fill, int xscale, int yscale, int startAngle, int endAngle, int x0, int y0) {
        int f = 1 - 5 * radius;
        int ddF_x = 0;
        int ddF_y = -10 * radius;
        int xc = 0;
        int yc = 5 * radius;
        int dotskip = 0;
        while (xc < yc) {
            if (f >= 0) {
                --yc;
                f += (ddF_y += 2);
            }
            ++xc;
            f += (ddF_x += 2) + 1;
            dotskip = (dotskip + 1) % 10;
            if (style == 2 && !fill && dotskip < 9) continue;
            int xxp = (xc * xscale + (xscale >> 1)) / 25;
            int xyp = (xc * yscale + (yscale >> 1)) / 25;
            int yyp = (yc * yscale + (yscale >> 1)) / 25;
            int yxp = (yc * xscale + (xscale >> 1)) / 25;
            int tp = (int)Math.round(Math.toDegrees(Math.atan2(yc, xc)));
            if (fill) {
                if (90 - tp >= startAngle && 90 - tp <= endAngle) {
                    this.drawLine(x0, y0, x0 + yxp, y0 - xyp, style);
                }
                if (tp >= startAngle && tp <= endAngle) {
                    this.drawLine(x0, y0, x0 + xxp, y0 - yyp, style);
                }
                if (180 - tp >= startAngle && 180 - tp <= endAngle) {
                    this.drawLine(x0, y0, x0 - xxp, y0 - yyp, style);
                }
                if (180 - (90 - tp) >= startAngle && 180 - (90 - tp) <= endAngle) {
                    this.drawLine(x0, y0, x0 - yxp, y0 - xyp, style);
                }
                if (270 - tp >= startAngle && 270 - tp <= endAngle) {
                    this.drawLine(x0, y0, x0 - yxp, y0 + xyp, style);
                }
                if (270 - (90 - tp) >= startAngle && 270 - (90 - tp) <= endAngle) {
                    this.drawLine(x0, y0, x0 - xxp, y0 + yyp, style);
                }
                if (360 - tp >= startAngle && 360 - tp <= endAngle) {
                    this.drawLine(x0, y0, x0 + xxp, y0 + yyp, style);
                }
                if (360 - (90 - tp) < startAngle || 360 - (90 - tp) > endAngle) continue;
                this.drawLine(x0, y0, x0 + yxp, y0 + xyp, style);
                continue;
            }
            if (90 - tp >= startAngle && 90 - tp <= endAngle) {
                this.setPixel(this.rgbColor, x0 + yxp, y0 - xyp);
            }
            if (tp >= startAngle && tp <= endAngle) {
                this.setPixel(this.rgbColor, x0 + xxp, y0 - yyp);
            }
            if (180 - tp >= startAngle && 180 - tp <= endAngle) {
                this.setPixel(this.rgbColor, x0 - xxp, y0 - yyp);
            }
            if (180 - (90 - tp) >= startAngle && 180 - (90 - tp) <= endAngle) {
                this.setPixel(this.rgbColor, x0 - yxp, y0 - xyp);
            }
            if (270 - tp >= startAngle && 270 - tp <= endAngle) {
                this.setPixel(this.rgbColor, x0 - yxp, y0 + xyp);
            }
            if (270 - (90 - tp) >= startAngle && 270 - (90 - tp) <= endAngle) {
                this.setPixel(this.rgbColor, x0 - xxp, y0 + yyp);
            }
            if (360 - tp >= startAngle && 360 - tp <= endAngle) {
                this.setPixel(this.rgbColor, x0 + xxp, y0 + yyp);
            }
            if (360 - (90 - tp) < startAngle || 360 - (90 - tp) > endAngle) continue;
            this.setPixel(this.rgbColor, x0 + yxp, y0 + xyp);
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int xc = x + width / 2;
        int yc = y + height / 2;
        int a = arcWidth / 2;
        int b = arcHeight / 2;
        int translateX = width / 2 - arcWidth / 2;
        int translateY = height / 2 - arcHeight / 2;
        int xDiff = arcWidth / 2;
        int yDiff = arcHeight / 2;
        this.drawLine(x, y + yDiff, x, height - yDiff);
        this.drawLine(width, y + yDiff, width, height - yDiff);
        this.drawLine(x + xDiff, y, width - xDiff, y);
        this.drawLine(x + xDiff, height, width - xDiff, height);
        int xxx = 0;
        int yyy = b;
        int a2 = a * a;
        int b2 = b * b;
        int crit1 = -(a2 / 4 + a % 2 + b2);
        int crit2 = -(b2 / 4 + b % 2 + a2);
        int crit3 = -(b2 / 4 + b % 2);
        int t = -a2 * yyy;
        int dxt = 2 * b2 * xxx;
        int dyt = -2 * a2 * yyy;
        int d2xt = 2 * b2;
        int d2yt = 2 * a2;
        while (yyy >= 0 && xxx <= a) {
            this.setPixel(1, xc + xxx + translateX, yc + yyy + translateY);
            if (xxx != 0 || yyy != 0) {
                this.setPixel(1, xc - xxx - translateX, yc - yyy - translateY);
            }
            if (xxx != 0 && yyy != 0) {
                this.setPixel(1, xc + xxx + translateX, yc - yyy - translateY);
                this.setPixel(1, xc - xxx - translateX, yc + yyy + translateY);
            }
            if (t + b2 * xxx <= crit1 || t + a2 * yyy <= crit3) {
                ++xxx;
                t += (dxt += d2xt);
                continue;
            }
            if (t - a2 * yyy > crit2) {
                --yyy;
                t += (dyt += d2yt);
                continue;
            }
            ++xxx;
            t += (dxt += d2xt);
            --yyy;
            t += (dyt += d2yt);
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        if (height == 0 || width == 0) {
            this.drawLine(x, y, x + width, y + height);
        } else {
            this.drawLine(x, y, x + width - 1, y);
            this.drawLine(x + width, y, x + width, y + height - 1);
            this.drawLine(x + width, y + height, x + 1, y + height);
            this.drawLine(x, y + height, x, y + 1);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        LCD.bitBlt(x, y, width, height, this.rgbColor == 1 ? 255 : 0);
    }

    public void drawString(String str, int x, int y, int rop) {
        LCD.drawString(str, x, y, rop);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 65280);
    }

    public void drawString(String str, int x, int y, boolean invert) {
        LCD.drawString(str, x, y, invert);
    }

    public void drawChar(char c, int x, int y, boolean invert) {
        LCD.drawChar(c, x, y, invert);
    }

    public void drawImage(Image img, int x, int y, boolean invert) {
        if (img == null) {
            return;
        }
        LCD.bitBlt(img.getData(), img.getWidth(), img.getHeight(), 0, 0, x, y, img.getWidth(), img.getHeight(), invert ? 65535 : 65280);
    }

    public void drawImage(Image img, int sx, int sy, int x, int y, int w, int h, int rop) {
        if (img == null) {
            LCD.bitBlt(x, y, w, h, rop);
        } else {
            LCD.bitBlt(img.getData(), img.getWidth(), img.getHeight(), sx, sy, x, y, w, h, rop);
        }
    }

    public int getStrokeStyle() {
        return this.strokeStyle;
    }

    public void setStrokeStyle(int style) {
        if (style != 0 && style != 2) {
            throw new IllegalArgumentException();
        }
        this.strokeStyle = style;
    }

    public void refresh() {
        LCD.setDisplay();
        LCD.refresh();
    }

    public void clear() {
        LCD.clearDisplay();
    }

    public void autoRefresh(boolean on) {
        LCD.setAutoRefresh(on ? 1 : 0);
    }
}

