/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.ArrayList;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;

public class List
extends Screen
implements Choice {
    private final Command SELECT_COMMAND = new Command(0, 1, 0);
    protected int listType;
    protected ArrayList<ListItem> listItems;
    private int scrollFirst = 0;
    private int scrollCurr = 0;
    private int scrollLast = 0;
    private boolean scrollWrap = true;

    public List(String title, int listType) {
        if (listType == 4) {
            throw new IllegalArgumentException();
        }
        this.title = title;
        this.listType = listType;
        this.listItems = new ArrayList();
    }

    public List(String title, int listType, String[] stringElements, Image[] imageElements) {
        if (listType == 4) {
            throw new IllegalArgumentException();
        }
        this.title = title;
        this.listType = listType;
        this.listItems = new ArrayList(stringElements.length);
        for (int i = 0; i < stringElements.length; ++i) {
            this.listItems.add(new ListItem(stringElements[i], imageElements[i]));
            ++this.scrollLast;
        }
    }

    public int append(String stringPart, Image imagePart) {
        this.listItems.add(new ListItem(stringPart, imagePart));
        ++this.scrollLast;
        return this.listItems.size();
    }

    public void delete(int elementNum) {
        --this.scrollLast;
        this.listItems.remove(elementNum);
    }

    public void deleteAll() {
        this.scrollLast = 0;
        this.listItems.clear();
    }

    public Image getImage(int elementNum) {
        return this.listItems.get((int)elementNum).img;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        selectedArray_return = new boolean[this.listItems.size()];
        for (int i = 0; i < selectedArray_return.length; ++i) {
            selectedArray_return[i] = this.listItems.get((int)i).selected;
        }
        return selectedArray_return.length;
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.listItems.size(); ++i) {
            if (!this.listItems.get((int)i).selected) continue;
            return i;
        }
        return -1;
    }

    public String getString(int elementNum) {
        return this.listItems.get((int)elementNum).str;
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        this.listItems.add(elementNum, new ListItem(stringPart, imagePart));
    }

    public boolean isSelected(int elementNum) {
        return this.listItems.get((int)elementNum).selected;
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        this.listItems.set(elementNum, new ListItem(stringPart, imagePart));
    }

    public void setScrollWrap(boolean scrollWrap) {
        this.scrollWrap = scrollWrap;
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        for (int i = 0; i < this.listItems.size(); ++i) {
            this.listItems.get((int)i).selected = selectedArray[i];
        }
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        if (this.listType == 2 || !selected) {
            this.listItems.get((int)elementNum).selected = selected;
        } else {
            for (int i = 0; i < this.listItems.size(); ++i) {
                ListItem li = this.listItems.get(i);
                li.selected = i == elementNum;
            }
        }
    }

    public int size() {
        return this.listItems.size();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 39) {
            if (this.scrollWrap) {
                this.scrollCurr = (this.scrollCurr + 1) % this.listItems.size();
            } else if (this.scrollCurr < this.listItems.size() - 1) {
                ++this.scrollCurr;
            }
            this.repaint();
        } else if (keyCode == 37) {
            if (this.scrollWrap) {
                this.scrollCurr = this.scrollCurr == 0 ? this.listItems.size() - 1 : this.scrollCurr - 1;
            } else if (this.scrollCurr > 0) {
                --this.scrollCurr;
            }
            this.repaint();
        } else if (keyCode == 40) {
            this.callCommandListener();
        } else if (keyCode == 38) {
            ListItem li = this.listItems.get(this.scrollCurr);
            if (this.listType == 3) {
                this.setSelectedIndex(this.scrollCurr, false);
            }
            this.setSelectedIndex(this.scrollCurr, !li.selected);
            if (this.listType == 3 && this.cmdListener != null) {
                this.cmdListener.commandAction(this.SELECT_COMMAND, this);
            }
            this.repaint();
        }
    }

    protected void paint(Graphics g) {
        int lineIdx = 0;
        int line = 8;
        int ch = 6;
        if (this.ticker != null) {
            ++lineIdx;
        }
        if (this.title != null) {
            g.drawString(this.title, 0, lineIdx++ * line);
        }
        int scrollLines = 8 - lineIdx;
        if (this.scrollCurr == 0) {
            this.scrollFirst = 0;
            this.scrollLast = scrollLines;
        } else if (this.listItems.size() >= scrollLines && this.scrollCurr >= this.listItems.size() - 1) {
            this.scrollFirst = this.listItems.size() - scrollLines;
            this.scrollLast = this.listItems.size() - 1;
        } else if (this.scrollCurr >= this.scrollLast) {
            ++this.scrollFirst;
            ++this.scrollLast;
        } else if (this.scrollCurr < this.scrollFirst) {
            --this.scrollFirst;
            --this.scrollLast;
        }
        for (int i = this.scrollFirst; i < this.listItems.size() && i <= this.scrollLast; ++i) {
            ListItem li = this.listItems.get(i);
            g.drawString(li.str, 2 * ch, lineIdx * line, i == this.scrollCurr);
            if (this.listType == 1 || this.listType == 2) {
                if (li.selected) {
                    g.fillArc(2, lineIdx * 8, 8, 8, 0, 360);
                } else {
                    g.drawArc(2, lineIdx * 8, 8, 8, 0, 360);
                }
            }
            ++lineIdx;
        }
    }

    private class ListItem {
        String str;
        Image img;
        boolean selected;

        ListItem(String stringPart, Image imagePart) {
            this.str = stringPart;
            this.img = imagePart;
            this.selected = false;
        }
    }
}

