/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import java.util.Enumeration;
import java.util.Vector;

public class Coordinates {
    private double latitude;
    private double longitude;
    private double altitude;
    public static final int DD_MM = 2;
    public static final int DD_MM_SS = 1;
    static final double EARTH_RADIUS = 6378137.0;
    static float calculatedDistance = Float.NaN;
    static float calculatedAzimuth = Float.NaN;

    public Coordinates(double latitude, double longitude, double altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public Coordinates(double latitude, double longitude) {
        this(latitude, longitude, 0.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double azimuthTo(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        Coordinates.calculateDistanceAndAzimuth(this.getLatitude(), this.getLongitude(), to.getLatitude(), to.getLongitude());
        while (calculatedAzimuth < 0.0f) {
            calculatedAzimuth += 360.0f;
        }
        while (calculatedAzimuth > 360.0f) {
            calculatedAzimuth -= 360.0f;
        }
        return calculatedAzimuth;
    }

    public static String convert(double coordinate, int outputType) throws IllegalArgumentException {
        if (coordinate < -180.0 || coordinate > 180.0) {
            throw new IllegalArgumentException();
        }
        int degrees = coordinate >= 0.0 ? (int)Math.floor(coordinate) : (int)Math.ceil(coordinate);
        String DD = Integer.toString(degrees);
        double decimalFracDegrees = Math.abs((coordinate - (double)degrees) * 100.0);
        int minutes = (int)Math.floor(decimalFracDegrees * 0.6);
        String MM = Integer.toString(minutes);
        if (outputType == 1) {
            double decimalFracMin = (decimalFracDegrees * 0.6 - (double)minutes) * 100.0;
            int ss = (int)Math.floor(decimalFracMin * 0.6 + 0.5);
            String SS = Integer.toString(ss);
            if (SS.length() == 1) {
                SS = "0" + SS;
            }
            int decimalFracSec = (int)Math.floor((decimalFracMin * 0.6 - (double)ss) * 1000.0 + 0.5);
            String SS_d = Coordinates.dropTrailingZeros(decimalFracSec);
            String out = DD + ":" + MM;
            if (SS_d != null) {
                out = out + ":" + SS + "." + SS_d;
            } else if (!SS.equals("00")) {
                out = out + ":" + SS;
            }
            return out;
        }
        if (outputType == 2) {
            double decimalFracMin = (decimalFracDegrees * 0.6 - (double)minutes) * 100000.0;
            int ss = (int)Math.floor(decimalFracMin + 0.5);
            String MM_d = Coordinates.dropTrailingZeros(ss);
            String out = DD + ":" + MM;
            if (MM_d != null) {
                out = out + "." + MM_d;
            }
            return out;
        }
        throw new IllegalArgumentException();
    }

    private static String dropTrailingZeros(int number) {
        if (number <= 0) {
            return null;
        }
        while (number % 10 == 0) {
            number /= 10;
        }
        return Integer.toString(number);
    }

    public static double convert(String coordinate) throws IllegalArgumentException, NullPointerException {
        if (coordinate == null) {
            throw new NullPointerException();
        }
        int length = coordinate.length();
        int colons = 0;
        int decimals = 0;
        for (int i = 0; i < length; ++i) {
            char element = coordinate.charAt(i);
            if (!Coordinates.convertIsValidChar(element)) {
                throw new IllegalArgumentException();
            }
            if (element == ':') {
                if (decimals > 0) {
                    throw new IllegalArgumentException();
                }
                ++colons;
                continue;
            }
            if (element != '.' || ++decimals <= 1) continue;
            throw new IllegalArgumentException();
        }
        String[] parts = Coordinates.convertSplit(coordinate);
        try {
            double out = 0.0;
            int degrees = Integer.valueOf(parts[0]);
            if (degrees < -180 || degrees > 179) {
                throw new IllegalArgumentException();
            }
            boolean negative = false;
            if (degrees < 0) {
                negative = true;
                degrees = Math.abs(degrees);
            }
            out += (double)degrees;
            int minutes = Integer.valueOf(parts[1]);
            if (minutes < 0 || minutes > 59) {
                throw new IllegalArgumentException();
            }
            out += (double)minutes * 0.1 / 6.0;
            if (colons == 2) {
                int seconds = Integer.valueOf(parts[2]);
                if (seconds < 0 || seconds > 59) {
                    throw new IllegalArgumentException();
                }
                out += (double)seconds * 0.01 / 36.0;
                if (decimals == 1) {
                    double decimalfrac = Double.valueOf("0." + parts[3]);
                    if (decimalfrac < 0.0 || decimalfrac >= 1.0) {
                        throw new IllegalArgumentException();
                    }
                    out += decimalfrac * 0.01 / 36.0;
                }
            } else if (colons == 1 && decimals == 1) {
                double decimalfrac = Double.valueOf("0." + parts[2]);
                if (decimalfrac < 0.0 || decimalfrac >= 1.0) {
                    throw new IllegalArgumentException();
                }
                out += decimalfrac * 0.1 / 6.0;
            } else {
                throw new IllegalArgumentException();
            }
            if (negative) {
                out = -out;
            }
            if (out < -180.0 || out >= 180.0) {
                throw new IllegalArgumentException();
            }
            return out;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean convertIsValidChar(char element) {
        return element == '-' || element == ':' || element == '.' || Character.isDigit(element);
    }

    private static String[] convertSplit(String in) throws IllegalArgumentException {
        Vector parts = new Vector(4);
        int start = 0;
        int length = in.length();
        for (int i = 0; i <= length; ++i) {
            if (i != length && in.charAt(i) != ':' && in.charAt(i) != '.') continue;
            if (start - i == 0) {
                throw new IllegalArgumentException();
            }
            String part = in.substring(start, i);
            parts.addElement(part);
            start = i + 1;
        }
        if (parts.size() < 2 || parts.size() > 4) {
            throw new IllegalArgumentException();
        }
        String[] partsArray = new String[parts.size()];
        Enumeration en = parts.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            partsArray[i] = (String)en.nextElement();
            ++i;
        }
        return partsArray;
    }

    public double distance(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        Coordinates.calculateDistanceAndAzimuth(this.getLatitude(), this.getLongitude(), to.getLatitude(), to.getLongitude());
        return calculatedDistance;
    }

    private static void calculateDistanceAndAzimuth(double d, double d1, double d2, double d3) {
        double d4 = Math.toRadians(d);
        double d5 = Math.toRadians(d1);
        double d6 = Math.toRadians(d2);
        double d7 = Math.toRadians(d3);
        double d8 = 0.0033528106647474805;
        double d9 = 0.0;
        double d10 = 0.0;
        double d20 = 0.0;
        double d22 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        double d32 = 0.0;
        double d33 = 5.0E-10;
        int i = 1;
        int byte0 = 100;
        if (d4 == d6 && (d5 == d7 || Math.abs(Math.abs(d5 - d7) - Math.PI * 2) < d33)) {
            calculatedDistance = 0.0f;
            calculatedAzimuth = 0.0f;
            return;
        }
        if (d4 + d6 == 0.0 && Math.abs(d5 - d7) == Math.PI) {
            d4 += 1.0E-5;
        }
        double d11 = 1.0 - d8;
        double d12 = d11 * Math.tan(d4);
        double d13 = d11 * Math.tan(d6);
        double d14 = 1.0 / Math.sqrt(1.0 + d12 * d12);
        double d15 = d14 * d12;
        double d16 = 1.0 / Math.sqrt(1.0 + d13 * d13);
        double d17 = d14 * d16;
        double d18 = d17 * d13;
        double d19 = d18 * d12;
        d9 = d7 - d5;
        d32 = d9 + 1.0;
        while (i < byte0 && Math.abs(d32 - d9) > d33) {
            ++i;
            double d21 = Math.sin(d9);
            double d23 = Math.cos(d9);
            d12 = d16 * d21;
            d13 = d18 - d15 * d16 * d23;
            d24 = Math.sqrt(d12 * d12 + d13 * d13);
            d25 = d17 * d23 + d19;
            d10 = Math.atan2(d24, d25);
            double d27 = d17 * d21 / d24;
            d28 = 1.0 - d27 * d27;
            d29 = 2.0 * d19;
            if (d28 > 0.0) {
                d29 = d25 - d29 / d28;
            }
            d30 = -1.0 + 2.0 * d29 * d29;
            d31 = ((-3.0 * d28 + 4.0) * d8 + 4.0) * d28 * d8 / 16.0;
            d32 = d9;
            d9 = ((d30 * d25 * d31 + d29) * d24 * d31 + d10) * d27;
            d9 = (1.0 - d31) * d9 * d8 + d7 - d5;
        }
        double d34 = Coordinates.mod(Math.atan2(d12, d13), Math.PI * 2);
        d9 = Math.sqrt((1.0 / (d11 * d11) - 1.0) * d28 + 1.0);
        d9 += 1.0;
        d9 = (d9 - 2.0) / d9;
        d31 = (d9 * d9 / 4.0 + 1.0) / (1.0 - d9);
        d32 = (d9 * d9 * 0.375 - 1.0) * d9;
        d9 = d30 * d25;
        double d35 = ((((d24 * d24 * 4.0 - 3.0) * (1.0 - d30 - d30) * d29 * d32 / 6.0 - d9) * d32 / 4.0 + d29) * d24 * d32 + d10) * d31 * 6378137.0 * d11;
        if ((double)Math.abs(i - byte0) < d33) {
            calculatedDistance = Float.NaN;
            calculatedAzimuth = Float.NaN;
            return;
        }
        d34 = 180.0 * d34 / Math.PI;
        calculatedDistance = (float)d35;
        calculatedAzimuth = (float)d34;
        if (d == 90.0) {
            calculatedAzimuth = 180.0f;
        } else if (d == -90.0) {
            calculatedAzimuth = 0.0f;
        }
    }

    private static double mod(double d, double d1) {
        return d - d1 * Math.floor(d / d1);
    }
}

