/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.keyboard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import lejos.addon.keyboard.KeyEvent;
import lejos.addon.keyboard.KeyListener;
import lejos.util.Delay;

public class Keyboard
extends Thread {
    private int typematicDelay = 500;
    private double typematicRate = 10.9;
    private int ratePause = (int)(1000.0 / this.typematicRate);
    private char lastKeyPress = NOT_ASCII_CHAR;
    private char oldChar = NOT_ASCII_CHAR;
    private static char NOT_ASCII_CHAR = (char)65535;
    private static int ECHO = 238;
    private boolean capsLock = false;
    private static int KEEP_ALIVE_DELAY = 4000;
    private InputStream in = null;
    private OutputStream out = null;
    private int modifiers;
    private KeyListener keyListener = null;
    private Keyboard kb = this;
    private Thread typematicThread = new Thread(){

        /*
         * Unable to fully structure code
         */
        public void run() {
            block0: while (true) {
                if (Keyboard.access$000(Keyboard.this) == Keyboard.access$100()) {
                    Thread.yield();
                    continue;
                }
                Keyboard.access$202(Keyboard.this, Keyboard.access$000(Keyboard.this));
                Delay.msDelay(Keyboard.access$300(Keyboard.this));
                while (true) {
                    if (Keyboard.access$000(Keyboard.this) != Keyboard.access$100() & Keyboard.access$200(Keyboard.this) == Keyboard.access$000(Keyboard.this)) ** break;
                    continue block0;
                    ke = new KeyEvent(Keyboard.access$400(Keyboard.this), 400, System.currentTimeMillis(), Keyboard.access$500(Keyboard.this), 0, Keyboard.access$000(Keyboard.this), 0);
                    Keyboard.access$600(Keyboard.this, ke);
                    Delay.msDelay(Keyboard.access$700(Keyboard.this));
                }
                break;
            }
        }
    };
    private static byte[] scanCodes = new byte[]{0, 120, 11, 116, 114, 112, 113, 13, 0, 121, 119, 117, 115, 9, 14, 0, 18, 18, 16, 6, 17, 81, 49, 0, 0, 0, 90, 83, 65, 87, 50, 0, 0, 67, 88, 68, 69, 52, 51, 0, 38, 32, 86, 70, 84, 82, 53, 39, 0, 78, 66, 72, 71, 89, 54, 0, 0, 0, 77, 74, 85, 55, 56, 0, 38, 44, 75, 73, 79, 48, 57, 0, 0, 46, 47, 76, 59, 80, 45, 0, 0, 0, 15, 0, 91, 61, 0, 0, 20, 16, 10, 93, 32, 92, 37, 0, 40, 0, 0, 0, 0, 0, 8, 0, 0, 35, 0, 37, 36, 0, 0, 0, 2, 127, 40, 0, 39, 38, 27, 4, 122, 5, 34, 109, 106};
    private DiscoveryAgent da;
    private RemoteDevice btDevice = null;
    private boolean doneInq = false;
    private static final int SPP_DEVICE = 7936;

    public Keyboard(InputStream in, OutputStream out) {
        this.setup(in, out);
    }

    private void setup(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.setDaemon(true);
        this.start();
        Keyboard.scanCodes[113] = 8;
        Keyboard.scanCodes[102] = 127;
        this.typematicThread.setDaemon(true);
        this.typematicThread.start();
    }

    public Keyboard() throws BluetoothStateException {
        DiscoveryListener dl = new DiscoveryListener(){

            public void deviceDiscovered(RemoteDevice btdev, DeviceClass cod) {
                if ((cod.getMajorDeviceClass() & 0x1F00) == 7936 && btdev.isAuthenticated()) {
                    Keyboard.this.btDevice = btdev;
                    Keyboard.this.da.cancelInquiry(this);
                }
            }

            public void inquiryCompleted(int discType) {
                Keyboard.this.doneInq = true;
            }
        };
        this.da = LocalDevice.getLocalDevice().getDiscoveryAgent();
        this.da.startInquiry(10390323, dl);
        while (!this.doneInq) {
            Thread.yield();
        }
        if (this.btDevice == null) {
            throw new BluetoothStateException("Nothing found.");
        }
        String address = this.btDevice.getBluetoothAddress();
        String btaddy = "btspp://" + address;
        try {
            StreamConnectionNotifier scn = (StreamConnectionNotifier)Connector.open(btaddy);
            if (scn == null) {
                throw new BluetoothStateException("Failed to connect.");
            }
            StreamConnection c = scn.acceptAndOpen();
            if (c == null) {
                throw new BluetoothStateException("Failed. Try pairing your device again.");
            }
            InputStream in = c.openInputStream();
            OutputStream out = c.openOutputStream();
            this.setup(in, out);
        }
        catch (IOException e) {
            throw new BluetoothStateException("Failed to retrieve data streams.");
        }
    }

    public void setTypematicDelay(int delay) {
        this.typematicDelay = delay;
    }

    public int getTypematicDelay() {
        return this.typematicDelay;
    }

    public void setTypematicRate(int rate) {
        this.typematicRate = rate;
        this.ratePause = (int)(1000.0 / this.typematicRate);
    }

    public double getTypematicRate() {
        return this.typematicRate;
    }

    public void addKeyListener(KeyListener kl) {
        this.keyListener = kl;
    }

    public void removeKeylistener(KeyListener kl) {
        if (this.keyListener == kl) {
            this.keyListener = null;
        }
    }

    private void notifyListeners(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        if (e.getID() == 401) {
            this.keyListener.keyPressed(e);
        } else if (e.getID() == 402) {
            this.keyListener.keyReleased(e);
        } else if (e.getID() == 400) {
            this.keyListener.keyTyped(e);
        }
    }

    public void run() {
        long previousEcho = System.currentTimeMillis();
        while (true) {
            long now;
            if ((now = System.currentTimeMillis()) - previousEcho >= (long)KEEP_ALIVE_DELAY) {
                try {
                    this.out.write(ECHO);
                    this.out.flush();
                }
                catch (IOException e) {
                    System.err.println("COMMAND EXCEPTION");
                }
                previousEcho = now;
            }
            try {
                if (this.in.available() > 0) {
                    int bval = this.in.read();
                    KeyEvent e = this.getKeyEvent(bval, System.currentTimeMillis());
                    if (e.getID() == 401) {
                        this.oldChar = NOT_ASCII_CHAR;
                        this.lastKeyPress = e.getKeyChar();
                    } else if (e.getID() == 402) {
                        this.lastKeyPress = NOT_ASCII_CHAR;
                    }
                    this.notifyListeners(e);
                    if (e.getID() == 401 & e.getKeyChar() != NOT_ASCII_CHAR) {
                        KeyEvent ke = new KeyEvent(this, 400, e.getWhen(), this.modifiers, 0, e.getKeyChar(), 0);
                        this.notifyListeners(ke);
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    private KeyEvent getKeyEvent(int scanCode, long timeStamp) {
        short id = 401;
        byte normalizedScanCode = (byte)scanCode;
        if ((byte)scanCode < 0) {
            normalizedScanCode = (byte)(scanCode - 128);
            id = 402;
        }
        int code = this.getJavaConstant(normalizedScanCode);
        this.recalculateModifier(code, id);
        if (code == 20 & id == 401) {
            this.capsLock = !this.capsLock;
        }
        int location = this.getLocation(normalizedScanCode);
        char curChar = this.getAsciiChar(code);
        return new KeyEvent(this, id, timeStamp, this.modifiers, code, curChar, location);
    }

    private int getLocation(int scanCode) {
        int location = 1;
        switch (scanCode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 31: {
                location = 2;
                break;
            }
            case 19: 
            case 89: {
                location = 3;
            }
        }
        return location;
    }

    public boolean isCapsLock() {
        return this.capsLock;
    }

    private char getAsciiChar(int code) {
        int ascii = code;
        boolean shifted = (this.modifiers & 1) == 1;
        if (code >= 65 & code <= 90) {
            boolean capitalize = this.isCapsLock() ^ shifted;
            if (!capitalize) {
                ascii += 32;
            }
            return (char)ascii;
        }
        if (code >= 48 & code <= 57) {
            if (shifted) {
                switch (code) {
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: {
                        ascii -= 16;
                        break;
                    }
                    case 55: 
                    case 57: {
                        ascii -= 17;
                        break;
                    }
                    case 50: {
                        ascii += 14;
                        break;
                    }
                    case 54: {
                        ascii += 40;
                        break;
                    }
                    case 56: {
                        ascii -= 14;
                        break;
                    }
                    case 48: {
                        ascii -= 7;
                    }
                }
            }
            return (char)ascii;
        }
        int shiftModifier = 0;
        switch (code) {
            case 32: {
                return (char)ascii;
            }
            case 45: {
                shiftModifier = shifted ? 50 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 61: {
                shiftModifier = shifted ? -18 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 91: 
            case 92: 
            case 93: {
                shiftModifier = shifted ? 32 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 59: {
                shiftModifier = shifted ? -1 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 15: {
                ascii = 39;
                shiftModifier = shifted ? -5 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 44: 
            case 46: 
            case 47: {
                shiftModifier = shifted ? 16 : 0;
                return (char)(ascii + shiftModifier);
            }
            case 14: {
                ascii = 96;
                shiftModifier = shifted ? 30 : 0;
                return (char)(ascii + shiftModifier);
            }
        }
        switch (code) {
            case 8: 
            case 9: 
            case 10: {
                return (char)ascii;
            }
        }
        return NOT_ASCII_CHAR;
    }

    private int getJavaConstant(byte scanCode) {
        if ((this.modifiers & 4) == 4) {
            switch (scanCodes[scanCode]) {
                case 14: {
                    return 27;
                }
                case 38: {
                    return 33;
                }
                case 40: {
                    return 34;
                }
                case 37: {
                    return 36;
                }
                case 39: {
                    return 35;
                }
            }
        }
        return scanCodes[scanCode];
    }

    private void recalculateModifier(int code, short id) {
        int val = 0;
        switch (code) {
            case 16: {
                val = 1;
                break;
            }
            case 17: {
                val = 2;
                break;
            }
            case 11: {
                val = 4;
                break;
            }
            case 18: {
                val = 8;
                break;
            }
            case 6: {
                val = 32;
            }
        }
        if (id == 401) {
            this.modifiers += val;
        } else if (id == 402) {
            this.modifiers -= val;
        }
    }

    static /* synthetic */ char access$000(Keyboard x0) {
        return x0.lastKeyPress;
    }

    static /* synthetic */ char access$100() {
        return NOT_ASCII_CHAR;
    }

    static /* synthetic */ char access$202(Keyboard x0, char x1) {
        x0.oldChar = x1;
        return x0.oldChar;
    }

    static /* synthetic */ int access$300(Keyboard x0) {
        return x0.typematicDelay;
    }

    static /* synthetic */ char access$200(Keyboard x0) {
        return x0.oldChar;
    }

    static /* synthetic */ Keyboard access$400(Keyboard x0) {
        return x0.kb;
    }

    static /* synthetic */ int access$500(Keyboard x0) {
        return x0.modifiers;
    }

    static /* synthetic */ void access$600(Keyboard x0, KeyEvent x1) {
        x0.notifyListeners(x1);
    }

    static /* synthetic */ int access$700(Keyboard x0) {
        return x0.ratePause;
    }
}

