/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.addon.PFMate;
import lejos.robotics.DCMotor;

public class PFMateMotor
implements DCMotor {
    private PFMate receiver;
    private int operReg;
    private int speedReg;
    private byte[] buffer = new byte[1];
    private static final byte FLT = 0;
    private static final byte FORWARD = 1;
    private static final byte BACKWARD = 2;
    private static final byte STOP = 3;
    private boolean moving = false;

    PFMateMotor(PFMate recever, int operReg, int speedReg) {
        this.receiver = recever;
        this.operReg = operReg;
        this.speedReg = speedReg;
    }

    public void flt() {
        this.receiver.sendData(this.operReg, (byte)0);
        this.moving = false;
    }

    public void forward() {
        this.receiver.sendData(this.operReg, (byte)1);
        this.receiver.sendData(65, (byte)71);
        this.moving = true;
    }

    public void backward() {
        this.receiver.sendData(this.operReg, (byte)2);
        this.receiver.sendData(65, (byte)71);
        this.moving = true;
    }

    public void stop() {
        this.receiver.sendData(this.operReg, (byte)3);
        this.receiver.sendData(65, (byte)71);
        this.moving = false;
    }

    public void setSpeed(int speed) {
        if (speed < 1) {
            speed = 1;
        }
        if (speed > 7) {
            speed = 7;
        }
        this.receiver.sendData(this.speedReg, (byte)speed);
        this.receiver.sendData(65, (byte)71);
    }

    public int getSpeed() {
        this.receiver.getData(this.speedReg, this.buffer, 1);
        return this.buffer[0];
    }

    public boolean isFlt() {
        this.receiver.getData(this.operReg, this.buffer, 1);
        return this.buffer[0] == 0;
    }

    public boolean isForward() {
        this.receiver.getData(this.operReg, this.buffer, 1);
        return this.buffer[0] == 1;
    }

    public boolean isBackward() {
        this.receiver.getData(this.operReg, this.buffer, 1);
        return this.buffer[0] == 2;
    }

    public boolean isStop() {
        this.receiver.getData(this.operReg, this.buffer, 1);
        return this.buffer[0] == 3;
    }

    public boolean isMoving() {
        return this.moving;
    }
}

