/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;
import lejos.nxt.addon.RCXMotor;
import lejos.nxt.addon.RCXRemoteMotorPort;
import lejos.nxt.rcxcomm.Opcode;
import lejos.util.Delay;

public class RCXLink
extends I2CSensor
implements Opcode {
    private byte[] buf = new byte[4];
    public RCXMotor A = new RCXMotor(new RCXRemoteMotorPort(this, 0));
    public RCXMotor B = new RCXMotor(new RCXRemoteMotorPort(this, 1));
    public RCXMotor C = new RCXMotor(new RCXRemoteMotorPort(this, 2));
    private static final byte SLOW_SPEED = 68;
    private static final byte FLUSH = 70;
    private static final byte HIGH_SPEED = 72;
    private static final byte SHORT_RANGE = 83;
    private static final byte LONG_RANGE = 76;
    private static final byte TRANSMIT_RAW_MACRO = 85;
    private static final byte COMMAND = 65;
    private static final byte RUN = 82;
    private static final byte ARPA_ON = 78;
    private static final byte ARPA_OFF = 79;
    private static final byte STATUS_REG = 65;
    private static final byte RX_DATA_LEN = 64;
    private static final byte TX_DATA_LEN = 64;
    private static final byte RX_DATA = 66;
    private static final byte TX_DATA = 66;
    public static final byte SHORT_RANGE_IR = 1;
    public static final byte LONG_RANGE_IR = 4;
    public static final byte POWER_OFF_RCX = 7;
    public static final byte RUN_PROGRAM_1 = 9;
    public static final byte RUN_PROGRAM_2 = 13;
    public static final byte RUN_PROGRAM_3 = 17;
    public static final byte RUN_PROGRAM_4 = 21;
    public static final byte RUN_PROGRAM_5 = 25;
    public static final byte STOP_ALL_PROGRAMS = 29;
    public static final byte MOTOR_A_FORWARD = 33;
    public static final byte MOTOR_A_REVERSED = 37;
    public static final byte MOTOR_B_FORWARD = 41;
    public static final byte MOTOR_B_REVERSED = 45;
    public static final byte MOTOR_C_FORWARD = 49;
    public static final byte MOTOR_C_REVERSED = 53;
    public static final byte BEEP = 57;
    public static final int EEPROM_BUFFER = 120;
    public static final int DELAY = 10;

    public RCXLink(I2CPort port) {
        super(port);
    }

    public void runMacro(int addr) {
        this.buf[0] = 82;
        this.buf[1] = (byte)addr;
        this.sendData(65, this.buf, 2);
    }

    public void beep() {
        this.runMacro(57);
    }

    public void runProgram(int programNumber) {
        this.runMacro(9 + (programNumber - 1) * 4);
    }

    public void forwardStep(int id) {
        this.runMacro(33 + id * 8);
    }

    public void backwardStep(int id) {
        this.runMacro(37 + id * 8);
    }

    public void setRCXRangeShort() {
        this.runMacro(1);
    }

    public void setRCXRangeLong() {
        this.runMacro(4);
    }

    public void powerOff() {
        this.runMacro(7);
    }

    public void stopAllPrograms() {
        this.runMacro(29);
    }

    public void flush() {
        this.sendData(65, (byte)70);
    }

    public void setDefaultSpeed() {
        this.sendData(65, (byte)68);
    }

    public void setHighSpeed() {
        this.sendData(65, (byte)72);
    }

    public void setRangeLong() {
        this.sendData(65, (byte)76);
    }

    public void setRangeShort() {
        this.sendData(65, (byte)83);
    }

    public void setAPDAOn() {
        this.sendData(65, (byte)78);
    }

    public void setAPDAOff() {
        this.sendData(65, (byte)79);
    }

    public void defineMacro(int addr, byte[] macro) {
        this.sendData((byte)addr, (byte)macro.length);
        this.sleep();
        this.sendData((byte)addr + 1, macro, macro.length);
    }

    public int getStatus() {
        this.getData(65, this.buf, 1);
        return this.buf[0] & 0xFF;
    }

    public int bytesAvailable() {
        this.getData(64, this.buf, 1);
        return this.buf[0] & 0xFF;
    }

    public void ping() {
        this.buf[0] = 16;
        this.defineAndRun(this.buf, 1);
    }

    public void sendF7(int msg) {
        this.buf[0] = -9;
        this.buf[1] = (byte)(msg & 0xFF);
        this.defineAndRun(this.buf, 2);
    }

    public void sendRemoteCommand(int msg) {
        this.buf[0] = -46;
        this.buf[1] = (byte)(msg >> 8);
        this.buf[2] = (byte)(msg & 0xFF);
        this.defineAndRun(this.buf, 3);
    }

    public void setMotorPower(int id, int power) {
        this.buf[0] = 19;
        this.buf[1] = (byte)(1 << id);
        this.buf[2] = 2;
        this.buf[3] = (byte)power;
        this.defineMacro(120, this.buf);
        this.sleep();
        this.sendData(124, (byte)power);
        this.sleep();
        this.runMacro(120);
    }

    public void stopMotor(int id) {
        this.buf[0] = 33;
        this.buf[1] = (byte)(1 << id | 0x40);
        this.defineAndRun(this.buf, 2);
    }

    public void startMotor(int id) {
        this.buf[0] = 33;
        this.buf[1] = (byte)(1 << id | 0x80);
        this.defineAndRun(this.buf, 2);
    }

    public void fltMotor(int id) {
        this.buf[0] = 33;
        this.buf[1] = (byte)(1 << id);
        this.defineAndRun(this.buf, 2);
    }

    public void forward(int id) {
        this.buf[0] = -31;
        this.buf[1] = (byte)(1 << id | 0x80);
        this.defineAndRun(this.buf, 2);
    }

    public void backward(int id) {
        this.buf[0] = -31;
        this.buf[1] = (byte)(1 << id);
        this.defineAndRun(this.buf, 2);
    }

    public void setRawMode() {
        this.sendData(65, (byte)85);
    }

    public void sendBytes(byte[] data, int len) {
        this.sendData(66, data, len);
        this.sleep();
        this.sendData(64, (byte)len);
    }

    public int readBytes(byte[] data) {
        this.getData(64, this.buf, 1);
        int numBytes = this.buf[0];
        if (numBytes > 0) {
            if (numBytes > data.length) {
                numBytes = data.length;
            }
            this.sleep();
            this.getData(66, data, numBytes);
        }
        return numBytes;
    }

    private void sleep() {
        Delay.msDelay(10L);
    }

    public void defineAndRun(byte[] macro, int len) {
        this.sendData(120, (byte)len);
        this.sleep();
        this.sendData(121, macro, len);
        this.sleep();
        this.runMacro(120);
    }
}

