/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.Bluetooth;
import lejos.nxt.comm.NXTConnection;

public class BTConnection
extends NXTConnection {
    private static final int BTC_FLUSH_WAIT = 10;
    public static final int AM_DISABLE = 0;
    public static final int AM_ALWAYS = 1;
    public static final int AM_OUTPUT = 2;
    int chanNo;
    byte handle;
    int switchMode;

    public BTConnection(int chan) {
        this.state = 0;
        this.chanNo = chan;
        this.bufSz = 256;
        this.is = null;
        this.os = null;
    }

    synchronized void reset() {
        this.state = 0;
        this.inBuf = null;
        this.outBuf = null;
        this.notifyAll();
    }

    synchronized void bind(byte handle, String address, int mode) {
        if (this.inBuf == null) {
            this.inBuf = new byte[256];
        }
        if (this.outBuf == null) {
            this.outBuf = new byte[256];
        }
        this.setIOMode(mode);
        this.inCnt = 0;
        this.inOffset = 0;
        this.outCnt = 0;
        this.outOffset = 0;
        this.state = 4;
        this.switchMode = 1;
        this.handle = handle;
        this.pktLen = 0;
        this.address = address;
    }

    synchronized void sendEOF() {
    }

    void disconnect() {
        Bluetooth.closeConnection(this.handle);
    }

    synchronized void send() {
        if (this.outOffset >= this.outCnt) {
            return;
        }
        int cnt = Bluetooth.btWrite(this.outBuf, this.outOffset, this.outCnt - this.outOffset);
        this.outOffset += cnt;
        if (this.outOffset >= this.outCnt) {
            this.outOffset = 0;
            this.outCnt = 0;
            this.notifyAll();
        }
    }

    synchronized int flushBuffer(boolean wait) {
        if (this.outOffset >= this.outCnt) {
            return 1;
        }
        if (wait) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.outCnt - this.outOffset;
    }

    synchronized void recv() {
        while (this.inCnt < this.inBuf.length) {
            int len;
            int offset;
            int cnt;
            if (this.inCnt == 0) {
                this.inOffset = 0;
            }
            if ((cnt = Bluetooth.btRead(this.inBuf, offset, len = (offset = (this.inOffset + this.inCnt) % this.inBuf.length) >= this.inOffset ? this.inBuf.length - offset : this.inOffset - offset)) <= 0) break;
            this.inCnt += cnt;
        }
        if (this.inCnt > 0) {
            this.notifyAll();
        }
    }

    synchronized int fillBuffer(boolean wait) {
        if (this.inCnt > 0) {
            return this.inCnt;
        }
        if (wait) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.inCnt;
    }

    synchronized boolean needsAttention() {
        if (this.state < 3 || this.switchMode == 0) {
            return false;
        }
        if (this.outOffset < this.outCnt) {
            return true;
        }
        if (this.switchMode == 2) {
            return false;
        }
        return this.inCnt <= 0;
    }

    public void setActiveMode(int mode) {
        this.switchMode = mode;
    }

    private boolean pendingInput() {
        return (Bluetooth.btPending() & 1) != 0;
    }

    synchronized void flushInput() {
        if (this.state == 0) {
            return;
        }
        int timeout = (int)System.currentTimeMillis() + 10;
        while (timeout > (int)System.currentTimeMillis()) {
            while (this.pendingInput() && this.inCnt < this.inBuf.length) {
                this.recv();
            }
            try {
                this.wait(1L);
            }
            catch (Exception exception) {}
        }
        if (!this.pendingInput()) {
            return;
        }
        timeout = (int)System.currentTimeMillis() + 10;
        while (this.pendingInput() || timeout > (int)System.currentTimeMillis()) {
            while (this.read(null, this.inBuf.length, false) > 0) {
            }
            this.recv();
        }
        if (this.state == 4) {
            this.state = 5;
        }
    }

    public void closeStream() {
    }

    public void openStream() {
    }

    public int getSignalStrength() {
        int strength = Bluetooth.getSignalStrength(this.handle);
        return strength;
    }
}

