/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.LCP;
import lejos.nxt.comm.NXTCommConnector;
import lejos.nxt.comm.NXTConnection;

public class LCPResponder
extends Thread {
    protected NXTCommConnector connector = null;
    protected NXTConnection conn = null;
    protected boolean running = true;

    public LCPResponder(NXTCommConnector connector) {
        this.connector = connector;
    }

    protected synchronized void waitConnect() {
        while (this.running && (this.conn = this.connector.waitForConnection(0, 1)) == null) {
            try {
                this.wait(500L);
            }
            catch (Exception exception) {}
        }
    }

    protected synchronized void disconnect() {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
    }

    protected int preCommand(byte[] inMsg, int len) {
        if (len < 0) {
            this.disconnect();
        }
        return len;
    }

    protected int command(byte[] inMsg, int len, byte[] reply) {
        return LCP.emulateCommand(inMsg, len, reply);
    }

    protected void postCommand(byte[] inMsg, int inLen, byte[] replyMsg, int replyLen) {
        if (inMsg[1] == LCP.NXJ_DISCONNECT) {
            this.disconnect();
        }
    }

    public void run() {
        byte[] inMsg = new byte[64];
        byte[] reply = new byte[64];
        while (this.running) {
            this.waitConnect();
            while (this.conn != null) {
                int len = this.conn.read(inMsg, 64);
                if ((len = this.preCommand(inMsg, len)) > 0) {
                    int replyLen = this.command(inMsg, len, reply);
                    if ((inMsg[0] & 0x80) == 0 && replyLen > 0) {
                        this.conn.write(reply, replyLen);
                    }
                    this.postCommand(inMsg, len, reply, replyLen);
                }
                Thread.yield();
            }
        }
    }

    public synchronized void shutdown() {
        this.running = false;
        if (this.conn == null) {
            super.interrupt();
        } else {
            this.disconnect();
        }
    }
}

