/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.SystemSettings;

public abstract class NXTCommDevice {
    public static final int ADDRESS_LEN = 6;
    public static final int NAME_LEN = 16;
    public static final String SERIAL_NO = "lejos.usb_serno";
    public static final String NAME = "lejos.usb_name";
    static String devAddress = "123";
    static String devName = "xxx";
    protected static final char[] cs;

    public static boolean isAddress(String s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        return s.charAt(0) == '0' && s.charAt(1) == '0';
    }

    public static byte[] stringToAddress(String strAddress) {
        if (strAddress != null && strAddress.length() == 12) {
            byte[] addr = new byte[6];
            int out = 0;
            for (int i = 0; i < strAddress.length(); i += 2) {
                char c = strAddress.charAt(i);
                byte val = (byte)((c > '9' ? c - 65 + 10 : c - 48) << 4);
                c = strAddress.charAt(i + 1);
                val = (byte)(val | (byte)(c > '9' ? c - 65 + 10 : c - 48));
                addr[out++] = val;
            }
            return addr;
        }
        return null;
    }

    public static byte[] stringToName(String strName) {
        if (strName != null && strName.length() <= 16) {
            byte[] nam = new byte[16];
            for (int i = 0; i < strName.length(); ++i) {
                nam[i] = (byte)strName.charAt(i);
            }
            return nam;
        }
        return null;
    }

    public static String addressToString(byte[] addr) {
        if (addr == null || addr.length < 6) {
            return null;
        }
        char[] caddr = new char[12];
        int ci = 0;
        int addri = 0;
        for (int i = 0; i < 6; ++i) {
            addri = addr[i] & 0xFF;
            caddr[ci++] = cs[addri / 16];
            caddr[ci++] = cs[addri % 16];
        }
        return new String(caddr);
    }

    public static String nameToString(byte[] name) {
        int len;
        if (name == null || name.length == 0) {
            return null;
        }
        for (len = name.length; len > 0 && name[len - 1] == 0; --len) {
        }
        char[] cname = new char[len];
        for (int i = 0; i < len; ++i) {
            cname[i] = (char)name[i];
        }
        return new String(cname);
    }

    public static void setAddress(String sn) {
        devAddress = sn;
    }

    public static String getAddress() {
        return devAddress;
    }

    public static void setName(String nam) {
        devName = nam;
    }

    public static String getName() {
        return devName;
    }

    public static void loadSettings() {
        devAddress = SystemSettings.getStringSetting(SERIAL_NO, "123456780090");
        devName = SystemSettings.getStringSetting(NAME, "nxt");
    }

    static {
        NXTCommDevice.loadSettings();
        cs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

