/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;
import lejos.nxt.comm.NXTInputStream;
import lejos.nxt.comm.NXTOutputStream;
import lejos.util.Delay;

public abstract class NXTConnection
implements StreamConnection {
    public static final int LCP = 1;
    public static final int PACKET = 0;
    public static final int RAW = 2;
    static final int CS_IDLE = 0;
    static final int CS_DISCONNECTED = 1;
    static final int CS_DISCONNECTING2 = 2;
    static final int CS_DISCONNECTING = 3;
    static final int CS_CONNECTED = 4;
    static final int CS_DATALOST = 5;
    static final int CS_EOF = 6;
    static final int DEF_HEADER = 2;
    private static final int CLOSETIMEOUT1 = 1000;
    private static final int CLOSETIMEOUT2 = 500;
    int state = 0;
    int header;
    byte[] inBuf;
    byte[] outBuf;
    int inCnt;
    int inOffset;
    int outCnt;
    int outOffset;
    int pktOffset;
    int pktLen;
    int bufSz;
    InputStream is;
    OutputStream os;
    String address;

    public String getAddress() {
        return this.address;
    }

    abstract int flushBuffer(boolean var1);

    public synchronized int write(byte[] data, int len, boolean wait) {
        int written;
        int offset = -this.header;
        int hdr = len;
        if (this.state == 5) {
            this.state = 4;
            return -2;
        }
        if (this.state < 4) {
            return -1;
        }
        if (this.outCnt > 0 && !wait) {
            return 0;
        }
        block0: while (offset < len) {
            while (this.outCnt >= this.outBuf.length) {
                if (!wait && this.header == 0) break block0;
                if (this.flushBuffer(true) < 0) {
                    this.disconnected();
                }
                if (this.state >= 4) continue;
                break block0;
            }
            if (offset < 0) {
                this.outBuf[this.outCnt++] = (byte)hdr;
                hdr >>= 8;
                ++offset;
                continue;
            }
            int cnt = this.outBuf.length - this.outCnt;
            if (cnt > len - offset) {
                cnt = len - offset;
            }
            System.arraycopy(data, offset, this.outBuf, this.outCnt, cnt);
            this.outCnt += cnt;
            offset += cnt;
        }
        if ((written = this.flushBuffer(wait)) > 0) {
            return offset;
        }
        if (written < 0) {
            this.disconnected();
        }
        return written;
    }

    abstract int fillBuffer(boolean var1);

    public synchronized int read(byte[] data, int outLen, boolean wait) {
        int offset = 0;
        if (this.state == 0) {
            return -3;
        }
        if (this.state == 5) {
            this.state = 4;
            return -2;
        }
        if (this.state == 6) {
            this.inCnt = 0;
            this.inOffset = 0;
            return -1;
        }
        if (this.fillBuffer(false) < 0) {
            this.disconnected();
        }
        if (this.state == 1 && this.inCnt <= 0) {
            return -1;
        }
        if (!wait && this.inCnt <= 0) {
            return 0;
        }
        if (this.header == 0) {
            this.pktOffset = 0;
            this.pktLen = outLen;
        }
        block0: while (this.pktOffset < this.pktLen) {
            while (this.inCnt <= 0) {
                if (!wait) {
                    return offset;
                }
                if (this.state != 4) {
                    if (offset > 0) break block0;
                    if (this.state == 1) {
                        return -1;
                    }
                    if (this.state == 5) {
                        this.state = 4;
                        return -2;
                    }
                    return -3;
                }
                if (this.fillBuffer(true) >= 0) continue;
                this.disconnected();
            }
            if (this.pktOffset < 0) {
                this.pktLen += (this.inBuf[this.inOffset++] & 0xFF) << (this.header + this.pktOffset) * 8;
                ++this.pktOffset;
                --this.inCnt;
            } else {
                int len;
                if (offset >= outLen) {
                    return offset;
                }
                int n = len = this.inOffset + this.inCnt > this.inBuf.length ? this.inBuf.length - this.inOffset : this.inCnt;
                if (len > outLen - offset) {
                    len = outLen - offset;
                }
                if (len > this.pktLen - this.pktOffset) {
                    len = this.pktLen - this.pktOffset;
                }
                if (data != null) {
                    System.arraycopy(this.inBuf, this.inOffset, data, offset, len);
                }
                offset += len;
                this.inOffset += len;
                this.pktOffset += len;
                this.inCnt -= len;
                if (this.header == 0) {
                    wait = false;
                }
            }
            this.inOffset %= this.inBuf.length;
        }
        this.pktOffset = -this.header;
        this.pktLen = 0;
        if (this.header > 0 && offset == 0) {
            this.state = 6;
            return -1;
        }
        return offset;
    }

    public synchronized int available(int what) {
        if (this.state == 0) {
            return -1;
        }
        if (this.state == 5) {
            this.state = 4;
            return -2;
        }
        this.fillBuffer(false);
        if (this.header > 0) {
            if (this.pktOffset < 0) {
                this.read(null, 0, false);
            }
            if (this.pktOffset < 0) {
                return 0;
            }
            if (what == 2) {
                return this.pktLen;
            }
            int ret = this.pktLen - this.pktOffset;
            if (what == 0 && ret > this.inCnt) {
                ret = this.inCnt;
            }
            return ret;
        }
        return this.inCnt;
    }

    public int available() {
        return this.available(0);
    }

    void setHeader(int sz) {
        this.header = sz;
        this.pktOffset = -this.header;
        this.pktLen = 0;
    }

    public void setIOMode(int mode) {
        if (mode == 0 || mode == 1) {
            this.setHeader(2);
        } else {
            this.setHeader(0);
        }
    }

    public int read(byte[] data, int len) {
        return this.read(data, len, true);
    }

    public int write(byte[] data, int len) {
        return this.write(data, len, true);
    }

    public InputStream openInputStream() {
        return this.is != null ? this.is : (this.is = new NXTInputStream(this, this.bufSz - this.header));
    }

    public OutputStream openOutputStream() {
        return this.os != null ? this.os : (this.os = new NXTOutputStream(this, this.bufSz - this.header));
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.openOutputStream());
    }

    synchronized boolean disconnected() {
        this.notifyAll();
        if (this.state <= 1) {
            return false;
        }
        this.freeConnection();
        this.state = 1;
        this.outCnt = 0;
        return true;
    }

    synchronized void sendEOF() {
        if (this.header > 0) {
            for (int i = 0; this.state >= 4 && this.outCnt > 0 && i < 500; ++i) {
                this.flushBuffer(false);
                try {
                    this.wait(1L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.write(null, 0, false);
        }
    }

    void disconnect() {
        this.disconnected();
    }

    void freeConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int i;
        if (this.state == 0) {
            return;
        }
        NXTConnection nXTConnection = this;
        synchronized (nXTConnection) {
            if (this.state >= 4) {
                this.sendEOF();
                this.state = 3;
            }
        }
        for (i = 0; this.state == 3 && this.outCnt > 0 && i < 1000; ++i) {
            this.flushBuffer(false);
            this.read(null, this.inBuf.length, false);
            Delay.msDelay(1L);
        }
        for (i = 0; this.state == 3 && i < 500; ++i) {
            this.flushBuffer(false);
            this.read(null, this.inBuf.length, false);
            Delay.msDelay(1L);
        }
        NXTConnection nXTConnection2 = this;
        synchronized (nXTConnection2) {
            this.outCnt = 0;
            if (this.state == 6) {
                this.state = 3;
            }
        }
        if (this.state == 3) {
            this.disconnect();
        }
        nXTConnection2 = this;
        synchronized (nXTConnection2) {
            while (this.state > 1) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.state = 0;
            this.inBuf = null;
            this.outBuf = null;
        }
    }

    synchronized void discardInput() {
        do {
            this.inCnt = 0;
            this.inOffset = 0;
            try {
                this.wait(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fillBuffer(false);
        } while (this.inCnt > 0);
        this.setHeader(this.header);
    }

    public int readPacket(byte[] buf, int len) {
        int pkt = this.available(1);
        if (pkt == -2) {
            return -2;
        }
        if (pkt < this.bufSz && this.available(0) < pkt) {
            return 0;
        }
        return this.read(buf, len, false);
    }

    public int sendPacket(byte[] buf, int bufLen) {
        if (bufLen <= this.outBuf.length - this.header) {
            return this.write(buf, bufLen, false);
        }
        return 0;
    }
}

