/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.OutputStream;
import java.io.PrintStream;
import lejos.nxt.LCD;
import lejos.nxt.comm.Bluetooth;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.USB;
import lejos.util.Delay;

public class RConsole
extends Thread {
    static PrintStream ps;
    static NXTConnection conn;
    static RConsole lcdThread;

    private RConsole() {
    }

    private static void init(NXTConnection c) {
        if (c == null) {
            LCD.drawString("No connection   ", 0, 0);
            return;
        }
        conn = c;
        try {
            LCD.drawString("Got connection  ", 0, 0);
            byte[] hello = new byte[32];
            int len = conn.read(hello, hello.length);
            if (len != 3 || hello[0] != 67 || hello[1] != 79 || hello[2] != 78 && hello[2] != 79) {
                LCD.drawString("Console no h/s    ", 0, 0);
                conn.close();
                return;
            }
            LCD.drawString("Console open    ", 0, 0);
            if (conn == null) {
                return;
            }
            ps = new PrintStream(conn.openOutputStream());
            LCD.refresh();
            RConsole.println("Console open");
            if (hello[2] == 79) {
                lcdThread = new RConsole();
                lcdThread.setDaemon(true);
                lcdThread.start();
            }
        }
        catch (Exception e) {
            LCD.drawString("Console error " + e.getMessage(), 0, 0);
            LCD.refresh();
        }
    }

    public static void openUSB(int timeout) {
        LCD.drawString("USB Console...  ", 0, 0);
        RConsole.init(USB.waitForConnection(timeout, 0));
    }

    public static void open() {
        RConsole.openUSB(0);
    }

    public static void openBluetooth(int timeout) {
        LCD.drawString("BT Console...   ", 0, 0);
        RConsole.init(Bluetooth.waitForConnection(timeout, 0, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String s) {
        if (ps == null) {
            return;
        }
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.print(s);
            ps.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String s) {
        if (ps == null) {
            return;
        }
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        if (conn == null) {
            return;
        }
        PrintStream printStream = ps;
        synchronized (printStream) {
            try {
                RConsole.println("Console closed");
                conn.close();
                LCD.drawString("Console closed  ", 0, 0);
                LCD.refresh();
                Delay.msDelay(2000L);
                ps = null;
                conn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isOpen() {
        return ps != null;
    }

    public static OutputStream openOutputStream() {
        return conn != null ? conn.openOutputStream() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream os = RConsole.openOutputStream();
        while (ps != null) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                try {
                    os.write(-1);
                    os.write(LCD.getDisplay());
                    os.flush();
                }
                catch (Exception e) {
                    break;
                }
            }
            Delay.msDelay(20L);
        }
    }
}

